﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotdeviceadvisor/IoTDeviceAdvisorRequest.h>
#include <aws/iotdeviceadvisor/IoTDeviceAdvisor_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoTDeviceAdvisor {
namespace Model {

/**
 */
class GetSuiteDefinitionRequest : public IoTDeviceAdvisorRequest {
 public:
  AWS_IOTDEVICEADVISOR_API GetSuiteDefinitionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetSuiteDefinition"; }

  AWS_IOTDEVICEADVISOR_API Aws::String SerializePayload() const override;

  AWS_IOTDEVICEADVISOR_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>Suite definition ID of the test suite to get.</p>
   */
  inline const Aws::String& GetSuiteDefinitionId() const { return m_suiteDefinitionId; }
  inline bool SuiteDefinitionIdHasBeenSet() const { return m_suiteDefinitionIdHasBeenSet; }
  template <typename SuiteDefinitionIdT = Aws::String>
  void SetSuiteDefinitionId(SuiteDefinitionIdT&& value) {
    m_suiteDefinitionIdHasBeenSet = true;
    m_suiteDefinitionId = std::forward<SuiteDefinitionIdT>(value);
  }
  template <typename SuiteDefinitionIdT = Aws::String>
  GetSuiteDefinitionRequest& WithSuiteDefinitionId(SuiteDefinitionIdT&& value) {
    SetSuiteDefinitionId(std::forward<SuiteDefinitionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Suite definition version of the test suite to get.</p>
   */
  inline const Aws::String& GetSuiteDefinitionVersion() const { return m_suiteDefinitionVersion; }
  inline bool SuiteDefinitionVersionHasBeenSet() const { return m_suiteDefinitionVersionHasBeenSet; }
  template <typename SuiteDefinitionVersionT = Aws::String>
  void SetSuiteDefinitionVersion(SuiteDefinitionVersionT&& value) {
    m_suiteDefinitionVersionHasBeenSet = true;
    m_suiteDefinitionVersion = std::forward<SuiteDefinitionVersionT>(value);
  }
  template <typename SuiteDefinitionVersionT = Aws::String>
  GetSuiteDefinitionRequest& WithSuiteDefinitionVersion(SuiteDefinitionVersionT&& value) {
    SetSuiteDefinitionVersion(std::forward<SuiteDefinitionVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_suiteDefinitionId;

  Aws::String m_suiteDefinitionVersion;
  bool m_suiteDefinitionIdHasBeenSet = false;
  bool m_suiteDefinitionVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTDeviceAdvisor
}  // namespace Aws
