﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/TableOptimizerRun.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class ListTableOptimizerRunsResult {
 public:
  AWS_GLUE_API ListTableOptimizerRunsResult() = default;
  AWS_GLUE_API ListTableOptimizerRunsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API ListTableOptimizerRunsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Catalog ID of the table.</p>
   */
  inline const Aws::String& GetCatalogId() const { return m_catalogId; }
  template <typename CatalogIdT = Aws::String>
  void SetCatalogId(CatalogIdT&& value) {
    m_catalogIdHasBeenSet = true;
    m_catalogId = std::forward<CatalogIdT>(value);
  }
  template <typename CatalogIdT = Aws::String>
  ListTableOptimizerRunsResult& WithCatalogId(CatalogIdT&& value) {
    SetCatalogId(std::forward<CatalogIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the database in the catalog in which the table resides.</p>
   */
  inline const Aws::String& GetDatabaseName() const { return m_databaseName; }
  template <typename DatabaseNameT = Aws::String>
  void SetDatabaseName(DatabaseNameT&& value) {
    m_databaseNameHasBeenSet = true;
    m_databaseName = std::forward<DatabaseNameT>(value);
  }
  template <typename DatabaseNameT = Aws::String>
  ListTableOptimizerRunsResult& WithDatabaseName(DatabaseNameT&& value) {
    SetDatabaseName(std::forward<DatabaseNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the table.</p>
   */
  inline const Aws::String& GetTableName() const { return m_tableName; }
  template <typename TableNameT = Aws::String>
  void SetTableName(TableNameT&& value) {
    m_tableNameHasBeenSet = true;
    m_tableName = std::forward<TableNameT>(value);
  }
  template <typename TableNameT = Aws::String>
  ListTableOptimizerRunsResult& WithTableName(TableNameT&& value) {
    SetTableName(std::forward<TableNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A continuation token for paginating the returned list of optimizer runs,
   * returned if the current segment of the list is not the last.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTableOptimizerRunsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of the optimizer runs associated with a table.</p>
   */
  inline const Aws::Vector<TableOptimizerRun>& GetTableOptimizerRuns() const { return m_tableOptimizerRuns; }
  template <typename TableOptimizerRunsT = Aws::Vector<TableOptimizerRun>>
  void SetTableOptimizerRuns(TableOptimizerRunsT&& value) {
    m_tableOptimizerRunsHasBeenSet = true;
    m_tableOptimizerRuns = std::forward<TableOptimizerRunsT>(value);
  }
  template <typename TableOptimizerRunsT = Aws::Vector<TableOptimizerRun>>
  ListTableOptimizerRunsResult& WithTableOptimizerRuns(TableOptimizerRunsT&& value) {
    SetTableOptimizerRuns(std::forward<TableOptimizerRunsT>(value));
    return *this;
  }
  template <typename TableOptimizerRunsT = TableOptimizerRun>
  ListTableOptimizerRunsResult& AddTableOptimizerRuns(TableOptimizerRunsT&& value) {
    m_tableOptimizerRunsHasBeenSet = true;
    m_tableOptimizerRuns.emplace_back(std::forward<TableOptimizerRunsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTableOptimizerRunsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_catalogId;

  Aws::String m_databaseName;

  Aws::String m_tableName;

  Aws::String m_nextToken;

  Aws::Vector<TableOptimizerRun> m_tableOptimizerRuns;

  Aws::String m_requestId;
  bool m_catalogIdHasBeenSet = false;
  bool m_databaseNameHasBeenSet = false;
  bool m_tableNameHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_tableOptimizerRunsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
