﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/forecast/ForecastService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ForecastService {
namespace Model {

/**
 * <p>Provides a summary of the forecast properties used in the
 * <a>ListForecasts</a> operation. To get the complete set of properties, call the
 * <a>DescribeForecast</a> operation, and provide the <code>ForecastArn</code> that
 * is listed in the summary.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ForecastSummary">AWS
 * API Reference</a></p>
 */
class ForecastSummary {
 public:
  AWS_FORECASTSERVICE_API ForecastSummary() = default;
  AWS_FORECASTSERVICE_API ForecastSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_FORECASTSERVICE_API ForecastSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FORECASTSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the forecast.</p>
   */
  inline const Aws::String& GetForecastArn() const { return m_forecastArn; }
  inline bool ForecastArnHasBeenSet() const { return m_forecastArnHasBeenSet; }
  template <typename ForecastArnT = Aws::String>
  void SetForecastArn(ForecastArnT&& value) {
    m_forecastArnHasBeenSet = true;
    m_forecastArn = std::forward<ForecastArnT>(value);
  }
  template <typename ForecastArnT = Aws::String>
  ForecastSummary& WithForecastArn(ForecastArnT&& value) {
    SetForecastArn(std::forward<ForecastArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the forecast.</p>
   */
  inline const Aws::String& GetForecastName() const { return m_forecastName; }
  inline bool ForecastNameHasBeenSet() const { return m_forecastNameHasBeenSet; }
  template <typename ForecastNameT = Aws::String>
  void SetForecastName(ForecastNameT&& value) {
    m_forecastNameHasBeenSet = true;
    m_forecastName = std::forward<ForecastNameT>(value);
  }
  template <typename ForecastNameT = Aws::String>
  ForecastSummary& WithForecastName(ForecastNameT&& value) {
    SetForecastName(std::forward<ForecastNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the predictor used to generate the forecast.</p>
   */
  inline const Aws::String& GetPredictorArn() const { return m_predictorArn; }
  inline bool PredictorArnHasBeenSet() const { return m_predictorArnHasBeenSet; }
  template <typename PredictorArnT = Aws::String>
  void SetPredictorArn(PredictorArnT&& value) {
    m_predictorArnHasBeenSet = true;
    m_predictorArn = std::forward<PredictorArnT>(value);
  }
  template <typename PredictorArnT = Aws::String>
  ForecastSummary& WithPredictorArn(PredictorArnT&& value) {
    SetPredictorArn(std::forward<PredictorArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the Forecast was created from an AutoPredictor.</p>
   */
  inline bool GetCreatedUsingAutoPredictor() const { return m_createdUsingAutoPredictor; }
  inline bool CreatedUsingAutoPredictorHasBeenSet() const { return m_createdUsingAutoPredictorHasBeenSet; }
  inline void SetCreatedUsingAutoPredictor(bool value) {
    m_createdUsingAutoPredictorHasBeenSet = true;
    m_createdUsingAutoPredictor = value;
  }
  inline ForecastSummary& WithCreatedUsingAutoPredictor(bool value) {
    SetCreatedUsingAutoPredictor(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the dataset group that provided the data
   * used to train the predictor.</p>
   */
  inline const Aws::String& GetDatasetGroupArn() const { return m_datasetGroupArn; }
  inline bool DatasetGroupArnHasBeenSet() const { return m_datasetGroupArnHasBeenSet; }
  template <typename DatasetGroupArnT = Aws::String>
  void SetDatasetGroupArn(DatasetGroupArnT&& value) {
    m_datasetGroupArnHasBeenSet = true;
    m_datasetGroupArn = std::forward<DatasetGroupArnT>(value);
  }
  template <typename DatasetGroupArnT = Aws::String>
  ForecastSummary& WithDatasetGroupArn(DatasetGroupArnT&& value) {
    SetDatasetGroupArn(std::forward<DatasetGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the forecast. States include:</p> <ul> <li> <p>
   * <code>ACTIVE</code> </p> </li> <li> <p> <code>CREATE_PENDING</code>,
   * <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code> </p> </li> <li> <p>
   * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code> </p> </li> <li> <p>
   * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>,
   * <code>DELETE_FAILED</code> </p> </li> </ul>  <p>The <code>Status</code> of
   * the forecast must be <code>ACTIVE</code> before you can query or export the
   * forecast.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  ForecastSummary& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If an error occurred, an informational message about the error.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  ForecastSummary& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the forecast creation task was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  ForecastSummary& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The last time the resource was modified. The timestamp depends on the status
   * of the job:</p> <ul> <li> <p> <code>CREATE_PENDING</code> - The
   * <code>CreationTime</code>.</p> </li> <li> <p> <code>CREATE_IN_PROGRESS</code> -
   * The current timestamp.</p> </li> <li> <p> <code>CREATE_STOPPING</code> - The
   * current timestamp.</p> </li> <li> <p> <code>CREATE_STOPPED</code> - When the job
   * stopped.</p> </li> <li> <p> <code>ACTIVE</code> or <code>CREATE_FAILED</code> -
   * When the job finished or failed.</p> </li> </ul>
   */
  inline const Aws::Utils::DateTime& GetLastModificationTime() const { return m_lastModificationTime; }
  inline bool LastModificationTimeHasBeenSet() const { return m_lastModificationTimeHasBeenSet; }
  template <typename LastModificationTimeT = Aws::Utils::DateTime>
  void SetLastModificationTime(LastModificationTimeT&& value) {
    m_lastModificationTimeHasBeenSet = true;
    m_lastModificationTime = std::forward<LastModificationTimeT>(value);
  }
  template <typename LastModificationTimeT = Aws::Utils::DateTime>
  ForecastSummary& WithLastModificationTime(LastModificationTimeT&& value) {
    SetLastModificationTime(std::forward<LastModificationTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_forecastArn;

  Aws::String m_forecastName;

  Aws::String m_predictorArn;

  bool m_createdUsingAutoPredictor{false};

  Aws::String m_datasetGroupArn;

  Aws::String m_status;

  Aws::String m_message;

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastModificationTime{};
  bool m_forecastArnHasBeenSet = false;
  bool m_forecastNameHasBeenSet = false;
  bool m_predictorArnHasBeenSet = false;
  bool m_createdUsingAutoPredictorHasBeenSet = false;
  bool m_datasetGroupArnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_messageHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastModificationTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ForecastService
}  // namespace Aws
