﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/email/SES_EXPORTS.h>
#include <aws/email/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace SES {
namespace Model {
/**
 * <p>The content of the custom verification email template.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetCustomVerificationEmailTemplateResponse">AWS
 * API Reference</a></p>
 */
class GetCustomVerificationEmailTemplateResult {
 public:
  AWS_SES_API GetCustomVerificationEmailTemplateResult() = default;
  AWS_SES_API GetCustomVerificationEmailTemplateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_SES_API GetCustomVerificationEmailTemplateResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The name of the custom verification email template.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  GetCustomVerificationEmailTemplateResult& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The email address that the custom verification email is sent from.</p>
   */
  inline const Aws::String& GetFromEmailAddress() const { return m_fromEmailAddress; }
  template <typename FromEmailAddressT = Aws::String>
  void SetFromEmailAddress(FromEmailAddressT&& value) {
    m_fromEmailAddressHasBeenSet = true;
    m_fromEmailAddress = std::forward<FromEmailAddressT>(value);
  }
  template <typename FromEmailAddressT = Aws::String>
  GetCustomVerificationEmailTemplateResult& WithFromEmailAddress(FromEmailAddressT&& value) {
    SetFromEmailAddress(std::forward<FromEmailAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The subject line of the custom verification email.</p>
   */
  inline const Aws::String& GetTemplateSubject() const { return m_templateSubject; }
  template <typename TemplateSubjectT = Aws::String>
  void SetTemplateSubject(TemplateSubjectT&& value) {
    m_templateSubjectHasBeenSet = true;
    m_templateSubject = std::forward<TemplateSubjectT>(value);
  }
  template <typename TemplateSubjectT = Aws::String>
  GetCustomVerificationEmailTemplateResult& WithTemplateSubject(TemplateSubjectT&& value) {
    SetTemplateSubject(std::forward<TemplateSubjectT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The content of the custom verification email.</p>
   */
  inline const Aws::String& GetTemplateContent() const { return m_templateContent; }
  template <typename TemplateContentT = Aws::String>
  void SetTemplateContent(TemplateContentT&& value) {
    m_templateContentHasBeenSet = true;
    m_templateContent = std::forward<TemplateContentT>(value);
  }
  template <typename TemplateContentT = Aws::String>
  GetCustomVerificationEmailTemplateResult& WithTemplateContent(TemplateContentT&& value) {
    SetTemplateContent(std::forward<TemplateContentT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL that the recipient of the verification email is sent to if his or her
   * address is successfully verified.</p>
   */
  inline const Aws::String& GetSuccessRedirectionURL() const { return m_successRedirectionURL; }
  template <typename SuccessRedirectionURLT = Aws::String>
  void SetSuccessRedirectionURL(SuccessRedirectionURLT&& value) {
    m_successRedirectionURLHasBeenSet = true;
    m_successRedirectionURL = std::forward<SuccessRedirectionURLT>(value);
  }
  template <typename SuccessRedirectionURLT = Aws::String>
  GetCustomVerificationEmailTemplateResult& WithSuccessRedirectionURL(SuccessRedirectionURLT&& value) {
    SetSuccessRedirectionURL(std::forward<SuccessRedirectionURLT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The URL that the recipient of the verification email is sent to if his or her
   * address is not successfully verified.</p>
   */
  inline const Aws::String& GetFailureRedirectionURL() const { return m_failureRedirectionURL; }
  template <typename FailureRedirectionURLT = Aws::String>
  void SetFailureRedirectionURL(FailureRedirectionURLT&& value) {
    m_failureRedirectionURLHasBeenSet = true;
    m_failureRedirectionURL = std::forward<FailureRedirectionURLT>(value);
  }
  template <typename FailureRedirectionURLT = Aws::String>
  GetCustomVerificationEmailTemplateResult& WithFailureRedirectionURL(FailureRedirectionURLT&& value) {
    SetFailureRedirectionURL(std::forward<FailureRedirectionURLT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  GetCustomVerificationEmailTemplateResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateName;

  Aws::String m_fromEmailAddress;

  Aws::String m_templateSubject;

  Aws::String m_templateContent;

  Aws::String m_successRedirectionURL;

  Aws::String m_failureRedirectionURL;

  ResponseMetadata m_responseMetadata;
  bool m_templateNameHasBeenSet = false;
  bool m_fromEmailAddressHasBeenSet = false;
  bool m_templateSubjectHasBeenSet = false;
  bool m_templateContentHasBeenSet = false;
  bool m_successRedirectionURLHasBeenSet = false;
  bool m_failureRedirectionURLHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace SES
}  // namespace Aws
