﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/discovery/ApplicationDiscoveryService_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApplicationDiscoveryService {
namespace Model {
class StopContinuousExportResult {
 public:
  AWS_APPLICATIONDISCOVERYSERVICE_API StopContinuousExportResult() = default;
  AWS_APPLICATIONDISCOVERYSERVICE_API StopContinuousExportResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APPLICATIONDISCOVERYSERVICE_API StopContinuousExportResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Timestamp that represents when this continuous export started collecting
   * data.</p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  StopContinuousExportResult& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Timestamp that represents when this continuous export was stopped.</p>
   */
  inline const Aws::Utils::DateTime& GetStopTime() const { return m_stopTime; }
  template <typename StopTimeT = Aws::Utils::DateTime>
  void SetStopTime(StopTimeT&& value) {
    m_stopTimeHasBeenSet = true;
    m_stopTime = std::forward<StopTimeT>(value);
  }
  template <typename StopTimeT = Aws::Utils::DateTime>
  StopContinuousExportResult& WithStopTime(StopTimeT&& value) {
    SetStopTime(std::forward<StopTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StopContinuousExportResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_startTime{};

  Aws::Utils::DateTime m_stopTime{};

  Aws::String m_requestId;
  bool m_startTimeHasBeenSet = false;
  bool m_stopTimeHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationDiscoveryService
}  // namespace Aws
