﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectCases {
namespace Model {

/**
 * <p>A filter for related items of type <code>Contact</code>.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ContactFilter">AWS
 * API Reference</a></p>
 */
class ContactFilter {
 public:
  AWS_CONNECTCASES_API ContactFilter() = default;
  AWS_CONNECTCASES_API ContactFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCASES_API ContactFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCASES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A list of channels to filter on for related items of type
   * <code>Contact</code>.</p>
   */
  inline const Aws::Vector<Aws::String>& GetChannel() const { return m_channel; }
  inline bool ChannelHasBeenSet() const { return m_channelHasBeenSet; }
  template <typename ChannelT = Aws::Vector<Aws::String>>
  void SetChannel(ChannelT&& value) {
    m_channelHasBeenSet = true;
    m_channel = std::forward<ChannelT>(value);
  }
  template <typename ChannelT = Aws::Vector<Aws::String>>
  ContactFilter& WithChannel(ChannelT&& value) {
    SetChannel(std::forward<ChannelT>(value));
    return *this;
  }
  template <typename ChannelT = Aws::String>
  ContactFilter& AddChannel(ChannelT&& value) {
    m_channelHasBeenSet = true;
    m_channel.emplace_back(std::forward<ChannelT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A unique identifier of a contact in Amazon Connect.</p>
   */
  inline const Aws::String& GetContactArn() const { return m_contactArn; }
  inline bool ContactArnHasBeenSet() const { return m_contactArnHasBeenSet; }
  template <typename ContactArnT = Aws::String>
  void SetContactArn(ContactArnT&& value) {
    m_contactArnHasBeenSet = true;
    m_contactArn = std::forward<ContactArnT>(value);
  }
  template <typename ContactArnT = Aws::String>
  ContactFilter& WithContactArn(ContactArnT&& value) {
    SetContactArn(std::forward<ContactArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_channel;

  Aws::String m_contactArn;
  bool m_channelHasBeenSet = false;
  bool m_contactArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCases
}  // namespace Aws
