﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/cognito-idp/model/TermsType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CognitoIdentityProvider {
namespace Model {
class CreateTermsResult {
 public:
  AWS_COGNITOIDENTITYPROVIDER_API CreateTermsResult() = default;
  AWS_COGNITOIDENTITYPROVIDER_API CreateTermsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COGNITOIDENTITYPROVIDER_API CreateTermsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A summary of your terms documents. Includes a unique identifier for later
   * changes to the terms documents.</p>
   */
  inline const TermsType& GetTerms() const { return m_terms; }
  template <typename TermsT = TermsType>
  void SetTerms(TermsT&& value) {
    m_termsHasBeenSet = true;
    m_terms = std::forward<TermsT>(value);
  }
  template <typename TermsT = TermsType>
  CreateTermsResult& WithTerms(TermsT&& value) {
    SetTerms(std::forward<TermsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateTermsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  TermsType m_terms;

  Aws::String m_requestId;
  bool m_termsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CognitoIdentityProvider
}  // namespace Aws
