﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudsearch/CloudSearch_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace CloudSearch {
namespace Model {

/**
 * <p>Options for a latlon field. A latlon field contains a location stored as a
 * latitude and longitude value pair. Present if <code>IndexFieldType</code>
 * specifies the field is of type <code>latlon</code>. All options are enabled by
 * default.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudsearch-2013-01-01/LatLonOptions">AWS
 * API Reference</a></p>
 */
class LatLonOptions {
 public:
  AWS_CLOUDSEARCH_API LatLonOptions() = default;
  AWS_CLOUDSEARCH_API LatLonOptions(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_CLOUDSEARCH_API LatLonOptions& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_CLOUDSEARCH_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_CLOUDSEARCH_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * A value to use for the field if the field isn't specified for a document.
   */
  inline const Aws::String& GetDefaultValue() const { return m_defaultValue; }
  inline bool DefaultValueHasBeenSet() const { return m_defaultValueHasBeenSet; }
  template <typename DefaultValueT = Aws::String>
  void SetDefaultValue(DefaultValueT&& value) {
    m_defaultValueHasBeenSet = true;
    m_defaultValue = std::forward<DefaultValueT>(value);
  }
  template <typename DefaultValueT = Aws::String>
  LatLonOptions& WithDefaultValue(DefaultValueT&& value) {
    SetDefaultValue(std::forward<DefaultValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetSourceField() const { return m_sourceField; }
  inline bool SourceFieldHasBeenSet() const { return m_sourceFieldHasBeenSet; }
  template <typename SourceFieldT = Aws::String>
  void SetSourceField(SourceFieldT&& value) {
    m_sourceFieldHasBeenSet = true;
    m_sourceField = std::forward<SourceFieldT>(value);
  }
  template <typename SourceFieldT = Aws::String>
  LatLonOptions& WithSourceField(SourceFieldT&& value) {
    SetSourceField(std::forward<SourceFieldT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether facet information can be returned for the field.</p>
   */
  inline bool GetFacetEnabled() const { return m_facetEnabled; }
  inline bool FacetEnabledHasBeenSet() const { return m_facetEnabledHasBeenSet; }
  inline void SetFacetEnabled(bool value) {
    m_facetEnabledHasBeenSet = true;
    m_facetEnabled = value;
  }
  inline LatLonOptions& WithFacetEnabled(bool value) {
    SetFacetEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the contents of the field are searchable.</p>
   */
  inline bool GetSearchEnabled() const { return m_searchEnabled; }
  inline bool SearchEnabledHasBeenSet() const { return m_searchEnabledHasBeenSet; }
  inline void SetSearchEnabled(bool value) {
    m_searchEnabledHasBeenSet = true;
    m_searchEnabled = value;
  }
  inline LatLonOptions& WithSearchEnabled(bool value) {
    SetSearchEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the contents of the field can be returned in the search results.</p>
   */
  inline bool GetReturnEnabled() const { return m_returnEnabled; }
  inline bool ReturnEnabledHasBeenSet() const { return m_returnEnabledHasBeenSet; }
  inline void SetReturnEnabled(bool value) {
    m_returnEnabledHasBeenSet = true;
    m_returnEnabled = value;
  }
  inline LatLonOptions& WithReturnEnabled(bool value) {
    SetReturnEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether the field can be used to sort the search results.</p>
   */
  inline bool GetSortEnabled() const { return m_sortEnabled; }
  inline bool SortEnabledHasBeenSet() const { return m_sortEnabledHasBeenSet; }
  inline void SetSortEnabled(bool value) {
    m_sortEnabledHasBeenSet = true;
    m_sortEnabled = value;
  }
  inline LatLonOptions& WithSortEnabled(bool value) {
    SetSortEnabled(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_defaultValue;

  Aws::String m_sourceField;

  bool m_facetEnabled{false};

  bool m_searchEnabled{false};

  bool m_returnEnabled{false};

  bool m_sortEnabled{false};
  bool m_defaultValueHasBeenSet = false;
  bool m_sourceFieldHasBeenSet = false;
  bool m_facetEnabledHasBeenSet = false;
  bool m_searchEnabledHasBeenSet = false;
  bool m_returnEnabledHasBeenSet = false;
  bool m_sortEnabledHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudSearch
}  // namespace Aws
