﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-messaging/ChimeSDKMessaging_EXPORTS.h>
#include <aws/chime-sdk-messaging/model/ErrorCode.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKMessaging {
namespace Model {

/**
 * <p>A list of failed member ARNs, error codes, and error messages.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/BatchCreateChannelMembershipError">AWS
 * API Reference</a></p>
 */
class BatchCreateChannelMembershipError {
 public:
  AWS_CHIMESDKMESSAGING_API BatchCreateChannelMembershipError() = default;
  AWS_CHIMESDKMESSAGING_API BatchCreateChannelMembershipError(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKMESSAGING_API BatchCreateChannelMembershipError& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKMESSAGING_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <code>AppInstanceUserArn</code> of the member that the service couldn't
   * add.</p>
   */
  inline const Aws::String& GetMemberArn() const { return m_memberArn; }
  inline bool MemberArnHasBeenSet() const { return m_memberArnHasBeenSet; }
  template <typename MemberArnT = Aws::String>
  void SetMemberArn(MemberArnT&& value) {
    m_memberArnHasBeenSet = true;
    m_memberArn = std::forward<MemberArnT>(value);
  }
  template <typename MemberArnT = Aws::String>
  BatchCreateChannelMembershipError& WithMemberArn(MemberArnT&& value) {
    SetMemberArn(std::forward<MemberArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error code.</p>
   */
  inline ErrorCode GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  inline void SetErrorCode(ErrorCode value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = value;
  }
  inline BatchCreateChannelMembershipError& WithErrorCode(ErrorCode value) {
    SetErrorCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The error message.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BatchCreateChannelMembershipError& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_memberArn;

  ErrorCode m_errorCode{ErrorCode::NOT_SET};

  Aws::String m_errorMessage;
  bool m_memberArnHasBeenSet = false;
  bool m_errorCodeHasBeenSet = false;
  bool m_errorMessageHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKMessaging
}  // namespace Aws
