﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/budgets/Budgets_EXPORTS.h>
#include <aws/budgets/model/ActionStatus.h>
#include <aws/budgets/model/ActionThreshold.h>
#include <aws/budgets/model/ActionType.h>
#include <aws/budgets/model/ApprovalModel.h>
#include <aws/budgets/model/Definition.h>
#include <aws/budgets/model/NotificationType.h>
#include <aws/budgets/model/Subscriber.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Budgets {
namespace Model {

/**
 * <p>A budget action resource. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/budgets-2016-10-20/Action">AWS API
 * Reference</a></p>
 */
class Action {
 public:
  AWS_BUDGETS_API Action() = default;
  AWS_BUDGETS_API Action(Aws::Utils::Json::JsonView jsonValue);
  AWS_BUDGETS_API Action& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BUDGETS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A system-generated universally unique identifier (UUID) for the action. </p>
   */
  inline const Aws::String& GetActionId() const { return m_actionId; }
  inline bool ActionIdHasBeenSet() const { return m_actionIdHasBeenSet; }
  template <typename ActionIdT = Aws::String>
  void SetActionId(ActionIdT&& value) {
    m_actionIdHasBeenSet = true;
    m_actionId = std::forward<ActionIdT>(value);
  }
  template <typename ActionIdT = Aws::String>
  Action& WithActionId(ActionIdT&& value) {
    SetActionId(std::forward<ActionIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetBudgetName() const { return m_budgetName; }
  inline bool BudgetNameHasBeenSet() const { return m_budgetNameHasBeenSet; }
  template <typename BudgetNameT = Aws::String>
  void SetBudgetName(BudgetNameT&& value) {
    m_budgetNameHasBeenSet = true;
    m_budgetName = std::forward<BudgetNameT>(value);
  }
  template <typename BudgetNameT = Aws::String>
  Action& WithBudgetName(BudgetNameT&& value) {
    SetBudgetName(std::forward<BudgetNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline NotificationType GetNotificationType() const { return m_notificationType; }
  inline bool NotificationTypeHasBeenSet() const { return m_notificationTypeHasBeenSet; }
  inline void SetNotificationType(NotificationType value) {
    m_notificationTypeHasBeenSet = true;
    m_notificationType = value;
  }
  inline Action& WithNotificationType(NotificationType value) {
    SetNotificationType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of action. This defines the type of tasks that can be carried out by
   * this action. This field also determines the format for definition. </p>
   */
  inline ActionType GetActionType() const { return m_actionType; }
  inline bool ActionTypeHasBeenSet() const { return m_actionTypeHasBeenSet; }
  inline void SetActionType(ActionType value) {
    m_actionTypeHasBeenSet = true;
    m_actionType = value;
  }
  inline Action& WithActionType(ActionType value) {
    SetActionType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The trigger threshold of the action. </p>
   */
  inline const ActionThreshold& GetActionThreshold() const { return m_actionThreshold; }
  inline bool ActionThresholdHasBeenSet() const { return m_actionThresholdHasBeenSet; }
  template <typename ActionThresholdT = ActionThreshold>
  void SetActionThreshold(ActionThresholdT&& value) {
    m_actionThresholdHasBeenSet = true;
    m_actionThreshold = std::forward<ActionThresholdT>(value);
  }
  template <typename ActionThresholdT = ActionThreshold>
  Action& WithActionThreshold(ActionThresholdT&& value) {
    SetActionThreshold(std::forward<ActionThresholdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Where you specify all of the type-specific parameters. </p>
   */
  inline const Definition& GetDefinition() const { return m_definition; }
  inline bool DefinitionHasBeenSet() const { return m_definitionHasBeenSet; }
  template <typename DefinitionT = Definition>
  void SetDefinition(DefinitionT&& value) {
    m_definitionHasBeenSet = true;
    m_definition = std::forward<DefinitionT>(value);
  }
  template <typename DefinitionT = Definition>
  Action& WithDefinition(DefinitionT&& value) {
    SetDefinition(std::forward<DefinitionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The role passed for action execution and reversion. Roles and actions must be
   * in the same account. </p>
   */
  inline const Aws::String& GetExecutionRoleArn() const { return m_executionRoleArn; }
  inline bool ExecutionRoleArnHasBeenSet() const { return m_executionRoleArnHasBeenSet; }
  template <typename ExecutionRoleArnT = Aws::String>
  void SetExecutionRoleArn(ExecutionRoleArnT&& value) {
    m_executionRoleArnHasBeenSet = true;
    m_executionRoleArn = std::forward<ExecutionRoleArnT>(value);
  }
  template <typename ExecutionRoleArnT = Aws::String>
  Action& WithExecutionRoleArn(ExecutionRoleArnT&& value) {
    SetExecutionRoleArn(std::forward<ExecutionRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This specifies if the action needs manual or automatic approval. </p>
   */
  inline ApprovalModel GetApprovalModel() const { return m_approvalModel; }
  inline bool ApprovalModelHasBeenSet() const { return m_approvalModelHasBeenSet; }
  inline void SetApprovalModel(ApprovalModel value) {
    m_approvalModelHasBeenSet = true;
    m_approvalModel = value;
  }
  inline Action& WithApprovalModel(ApprovalModel value) {
    SetApprovalModel(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the action. </p>
   */
  inline ActionStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(ActionStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline Action& WithStatus(ActionStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Subscriber>& GetSubscribers() const { return m_subscribers; }
  inline bool SubscribersHasBeenSet() const { return m_subscribersHasBeenSet; }
  template <typename SubscribersT = Aws::Vector<Subscriber>>
  void SetSubscribers(SubscribersT&& value) {
    m_subscribersHasBeenSet = true;
    m_subscribers = std::forward<SubscribersT>(value);
  }
  template <typename SubscribersT = Aws::Vector<Subscriber>>
  Action& WithSubscribers(SubscribersT&& value) {
    SetSubscribers(std::forward<SubscribersT>(value));
    return *this;
  }
  template <typename SubscribersT = Subscriber>
  Action& AddSubscribers(SubscribersT&& value) {
    m_subscribersHasBeenSet = true;
    m_subscribers.emplace_back(std::forward<SubscribersT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_actionId;

  Aws::String m_budgetName;

  NotificationType m_notificationType{NotificationType::NOT_SET};

  ActionType m_actionType{ActionType::NOT_SET};

  ActionThreshold m_actionThreshold;

  Definition m_definition;

  Aws::String m_executionRoleArn;

  ApprovalModel m_approvalModel{ApprovalModel::NOT_SET};

  ActionStatus m_status{ActionStatus::NOT_SET};

  Aws::Vector<Subscriber> m_subscribers;
  bool m_actionIdHasBeenSet = false;
  bool m_budgetNameHasBeenSet = false;
  bool m_notificationTypeHasBeenSet = false;
  bool m_actionTypeHasBeenSet = false;
  bool m_actionThresholdHasBeenSet = false;
  bool m_definitionHasBeenSet = false;
  bool m_executionRoleArnHasBeenSet = false;
  bool m_approvalModelHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_subscribersHasBeenSet = false;
};

}  // namespace Model
}  // namespace Budgets
}  // namespace Aws
