﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/braket/Braket_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Braket {
namespace Model {

/**
 * <p>Specifies limits for how long an Amazon Braket hybrid job can run.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/braket-2019-09-01/JobStoppingCondition">AWS
 * API Reference</a></p>
 */
class JobStoppingCondition {
 public:
  AWS_BRAKET_API JobStoppingCondition() = default;
  AWS_BRAKET_API JobStoppingCondition(Aws::Utils::Json::JsonView jsonValue);
  AWS_BRAKET_API JobStoppingCondition& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BRAKET_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The maximum length of time, in seconds, that an Amazon Braket hybrid job can
   * run.</p>
   */
  inline int GetMaxRuntimeInSeconds() const { return m_maxRuntimeInSeconds; }
  inline bool MaxRuntimeInSecondsHasBeenSet() const { return m_maxRuntimeInSecondsHasBeenSet; }
  inline void SetMaxRuntimeInSeconds(int value) {
    m_maxRuntimeInSecondsHasBeenSet = true;
    m_maxRuntimeInSeconds = value;
  }
  inline JobStoppingCondition& WithMaxRuntimeInSeconds(int value) {
    SetMaxRuntimeInSeconds(value);
    return *this;
  }
  ///@}
 private:
  int m_maxRuntimeInSeconds{0};
  bool m_maxRuntimeInSecondsHasBeenSet = false;
};

}  // namespace Model
}  // namespace Braket
}  // namespace Aws
