﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/billingconductor/BillingConductor_EXPORTS.h>
#include <aws/billingconductor/model/PricingPlanListElement.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace BillingConductor {
namespace Model {
class ListPricingPlansResult {
 public:
  AWS_BILLINGCONDUCTOR_API ListPricingPlansResult() = default;
  AWS_BILLINGCONDUCTOR_API ListPricingPlansResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_BILLINGCONDUCTOR_API ListPricingPlansResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The billing period for which the described pricing plans are applicable.
   * </p>
   */
  inline const Aws::String& GetBillingPeriod() const { return m_billingPeriod; }
  template <typename BillingPeriodT = Aws::String>
  void SetBillingPeriod(BillingPeriodT&& value) {
    m_billingPeriodHasBeenSet = true;
    m_billingPeriod = std::forward<BillingPeriodT>(value);
  }
  template <typename BillingPeriodT = Aws::String>
  ListPricingPlansResult& WithBillingPeriod(BillingPeriodT&& value) {
    SetBillingPeriod(std::forward<BillingPeriodT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>PricingPlanListElement</code> retrieved. </p>
   */
  inline const Aws::Vector<PricingPlanListElement>& GetPricingPlans() const { return m_pricingPlans; }
  template <typename PricingPlansT = Aws::Vector<PricingPlanListElement>>
  void SetPricingPlans(PricingPlansT&& value) {
    m_pricingPlansHasBeenSet = true;
    m_pricingPlans = std::forward<PricingPlansT>(value);
  }
  template <typename PricingPlansT = Aws::Vector<PricingPlanListElement>>
  ListPricingPlansResult& WithPricingPlans(PricingPlansT&& value) {
    SetPricingPlans(std::forward<PricingPlansT>(value));
    return *this;
  }
  template <typename PricingPlansT = PricingPlanListElement>
  ListPricingPlansResult& AddPricingPlans(PricingPlansT&& value) {
    m_pricingPlansHasBeenSet = true;
    m_pricingPlans.emplace_back(std::forward<PricingPlansT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The pagination token that's used on subsequent calls to get pricing plans.
   * </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPricingPlansResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPricingPlansResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_billingPeriod;

  Aws::Vector<PricingPlanListElement> m_pricingPlans;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_billingPeriodHasBeenSet = false;
  bool m_pricingPlansHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace BillingConductor
}  // namespace Aws
