﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace Bedrock {
namespace Model {
enum class VectorSearchRerankingConfigurationType { NOT_SET, BEDROCK_RERANKING_MODEL };

namespace VectorSearchRerankingConfigurationTypeMapper {
AWS_BEDROCK_API VectorSearchRerankingConfigurationType GetVectorSearchRerankingConfigurationTypeForName(const Aws::String& name);

AWS_BEDROCK_API Aws::String GetNameForVectorSearchRerankingConfigurationType(VectorSearchRerankingConfigurationType value);
}  // namespace VectorSearchRerankingConfigurationTypeMapper
}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
