﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/NotebookMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListNotebookMetadataResult {
 public:
  AWS_ATHENA_API ListNotebookMetadataResult() = default;
  AWS_ATHENA_API ListNotebookMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListNotebookMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the <code>NextToken</code> from the response object of the previous page
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListNotebookMetadataResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of notebook metadata for the specified workgroup.</p>
   */
  inline const Aws::Vector<NotebookMetadata>& GetNotebookMetadataList() const { return m_notebookMetadataList; }
  template <typename NotebookMetadataListT = Aws::Vector<NotebookMetadata>>
  void SetNotebookMetadataList(NotebookMetadataListT&& value) {
    m_notebookMetadataListHasBeenSet = true;
    m_notebookMetadataList = std::forward<NotebookMetadataListT>(value);
  }
  template <typename NotebookMetadataListT = Aws::Vector<NotebookMetadata>>
  ListNotebookMetadataResult& WithNotebookMetadataList(NotebookMetadataListT&& value) {
    SetNotebookMetadataList(std::forward<NotebookMetadataListT>(value));
    return *this;
  }
  template <typename NotebookMetadataListT = NotebookMetadata>
  ListNotebookMetadataResult& AddNotebookMetadataList(NotebookMetadataListT&& value) {
    m_notebookMetadataListHasBeenSet = true;
    m_notebookMetadataList.emplace_back(std::forward<NotebookMetadataListT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListNotebookMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<NotebookMetadata> m_notebookMetadataList;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_notebookMetadataListHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
