﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appconfig/AppConfigRequest.h>
#include <aws/appconfig/AppConfig_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppConfig {
namespace Model {

/**
 */
class GetHostedConfigurationVersionRequest : public AppConfigRequest {
 public:
  AWS_APPCONFIG_API GetHostedConfigurationVersionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetHostedConfigurationVersion"; }

  AWS_APPCONFIG_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The application ID.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  GetHostedConfigurationVersionRequest& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The configuration profile ID.</p>
   */
  inline const Aws::String& GetConfigurationProfileId() const { return m_configurationProfileId; }
  inline bool ConfigurationProfileIdHasBeenSet() const { return m_configurationProfileIdHasBeenSet; }
  template <typename ConfigurationProfileIdT = Aws::String>
  void SetConfigurationProfileId(ConfigurationProfileIdT&& value) {
    m_configurationProfileIdHasBeenSet = true;
    m_configurationProfileId = std::forward<ConfigurationProfileIdT>(value);
  }
  template <typename ConfigurationProfileIdT = Aws::String>
  GetHostedConfigurationVersionRequest& WithConfigurationProfileId(ConfigurationProfileIdT&& value) {
    SetConfigurationProfileId(std::forward<ConfigurationProfileIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version.</p>
   */
  inline int GetVersionNumber() const { return m_versionNumber; }
  inline bool VersionNumberHasBeenSet() const { return m_versionNumberHasBeenSet; }
  inline void SetVersionNumber(int value) {
    m_versionNumberHasBeenSet = true;
    m_versionNumber = value;
  }
  inline GetHostedConfigurationVersionRequest& WithVersionNumber(int value) {
    SetVersionNumber(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;

  Aws::String m_configurationProfileId;

  int m_versionNumber{0};
  bool m_applicationIdHasBeenSet = false;
  bool m_configurationProfileIdHasBeenSet = false;
  bool m_versionNumberHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppConfig
}  // namespace Aws
