#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
module: networks_appliance_security_malware
short_description: Resource module for networks _appliance _security _malware
description:
  - Manage operation update of the resource networks _appliance _security _malware.
  - Set the supported malware settings for an MX network.
version_added: '1.0.0'
extends_documentation_fragment:
  - cisco.meraki.module
author: Francisco Munoz (@fmunoz)
options:
  allowedFiles:
    description: The sha256 digests of files that should be permitted by the malware detection engine. If omitted, the current config will remain
      unchanged. This is available only if your network supports AMP allow listing.
    elements: dict
    suboptions:
      comment:
        description: Comment about the allowed entity.
        type: str
      sha256:
        description: The file sha256 hash to allow.
        type: str
    type: list
  allowedUrls:
    description: The urls that should be permitted by the malware detection engine. If omitted, the current config will remain unchanged. This
      is available only if your network supports AMP allow listing.
    elements: dict
    suboptions:
      comment:
        description: Comment about the allowed entity.
        type: str
      url:
        description: The url to allow.
        type: str
    type: list
  mode:
    description: Set mode to 'enabled' to enable malware prevention, otherwise 'disabled'.
    type: str
  networkId:
    description: NetworkId path parameter. Network ID.
    type: str
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - name: Cisco Meraki documentation for appliance updateNetworkApplianceSecurityMalware
    description: Complete reference of the updateNetworkApplianceSecurityMalware API.
    link: https://developer.cisco.com/meraki/api-v1/#!update-network-appliance-security-malware
notes:
  - SDK Method used are
    appliance.Appliance.update_network_appliance_security_malware,
  - Paths used are
    put /networks/{networkId}/appliance/security/malware,
"""

EXAMPLES = r"""
- name: Update all
  cisco.meraki.networks_appliance_security_malware:
    meraki_api_key: "{{ meraki_api_key }}"
    meraki_base_url: "{{ meraki_base_url }}"
    meraki_single_request_timeout: "{{ meraki_single_request_timeout }}"
    meraki_certificate_path: "{{ meraki_certificate_path }}"
    meraki_requests_proxy: "{{ meraki_requests_proxy }}"
    meraki_wait_on_rate_limit: "{{ meraki_wait_on_rate_limit }}"
    meraki_nginx_429_retry_wait_time: "{{ meraki_nginx_429_retry_wait_time }}"
    meraki_action_batch_retry_wait_time: "{{ meraki_action_batch_retry_wait_time }}"
    meraki_retry_4xx_error: "{{ meraki_retry_4xx_error }}"
    meraki_retry_4xx_error_wait_time: "{{ meraki_retry_4xx_error_wait_time }}"
    meraki_maximum_retries: "{{ meraki_maximum_retries }}"
    meraki_output_log: "{{ meraki_output_log }}"
    meraki_log_file_prefix: "{{ meraki_log_file_prefix }}"
    meraki_log_path: "{{ meraki_log_path }}"
    meraki_print_console: "{{ meraki_print_console }}"
    meraki_suppress_logging: "{{ meraki_suppress_logging }}"
    meraki_simulate: "{{ meraki_simulate }}"
    meraki_be_geo_id: "{{ meraki_be_geo_id }}"
    meraki_caller: "{{ meraki_caller }}"
    meraki_use_iterator_for_get_pages: "{{ meraki_use_iterator_for_get_pages }}"
    meraki_inherit_logging_config: "{{ meraki_inherit_logging_config }}"
    state: present
    allowedFiles:
      - comment: allow ZIP file
        sha256: e82c5f7d75004727e1f3b94426b9a11c8bc4c312a9170ac9a73abace40aef503
    allowedUrls:
      - comment: allow help.com.au
        url: help.com.au
    mode: enabled
    networkId: string
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "allowedFiles": [
        {
          "comment": "string",
          "sha256": "string"
        }
      ],
      "allowedUrls": [
        {
          "comment": "string",
          "url": "string"
        }
      ],
      "mode": "string"
    }
"""
