"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exploreUiSettings = void 0;
var _i18n = require("@osd/i18n");
var _configSchema = require("@osd/config-schema");
var _common = require("../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const exploreUiSettings = exports.exploreUiSettings = {
  [_common.DEFAULT_TRACE_COLUMNS_SETTING]: {
    name: _i18n.i18n.translate('explore.advancedSettings.defaultTraceColumnsTitle', {
      defaultMessage: 'Default trace columns'
    }),
    value: ['spanId', 'status.code', 'attributes.http.status_code', 'resource.attributes.service.name', 'kind', 'name', 'durationNano', 'durationInNanos'],
    description: _i18n.i18n.translate('explore.advancedSettings.defaultTraceColumnsText', {
      defaultMessage: 'Experimental: Columns displayed by default in the Explore traces tab'
    }),
    category: ['explore'],
    schema: _configSchema.schema.arrayOf(_configSchema.schema.string())
  },
  [_common.DEFAULT_LOGS_COLUMNS_SETTING]: {
    name: _i18n.i18n.translate('explore.advancedSettings.defaultLogsColumnsTitle', {
      defaultMessage: 'Default logs columns'
    }),
    value: ['body', 'severityText', 'resource.attributes.service.name'],
    description: _i18n.i18n.translate('explore.advancedSettings.defaultLogsColumnsText', {
      defaultMessage: 'Columns displayed by default in the Explore logs tab'
    }),
    category: ['explore'],
    schema: _configSchema.schema.arrayOf(_configSchema.schema.string())
  },
  [_common.ENABLE_EXPERIMENTAL_SETTING]: {
    name: _i18n.i18n.translate('explore.advancedSettings.enableExperimentalTitle', {
      defaultMessage: 'Enable experimental features'
    }),
    value: false,
    description: _i18n.i18n.translate('explore.advancedSettings.enableExperimentalText', {
      defaultMessage: 'Enable experimental features in Explore including field statistics and histogram breakdown selector.'
    }),
    category: ['explore'],
    schema: _configSchema.schema.boolean()
  }
};