/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.store;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.PointStore;
import java.util.Arrays;

public class PointStoreSmall
extends PointStore {
    public static char INFEASIBLE_SMALL_POINTSTORE_LOCN = (char)PointStore.INFEASIBLE_LOCN;
    protected char[] locationList;

    @Override
    void setInfeasiblePointstoreLocationIndex(int index) {
        this.locationList[index] = INFEASIBLE_SMALL_POINTSTORE_LOCN;
    }

    @Override
    void extendLocationList(int newCapacity) {
        int oldCapacity = this.locationList.length;
        assert (oldCapacity < newCapacity);
        this.locationList = Arrays.copyOf(this.locationList, newCapacity);
        for (int i = oldCapacity; i < newCapacity; ++i) {
            this.locationList[i] = INFEASIBLE_SMALL_POINTSTORE_LOCN;
        }
    }

    @Override
    void setLocation(int index, int location) {
        this.locationList[index] = (char)(location / this.baseDimension);
        assert (this.baseDimension * this.locationList[index] == location);
    }

    @Override
    int getLocation(int index) {
        return this.baseDimension * this.locationList[index];
    }

    @Override
    int locationListLength() {
        return this.locationList.length;
    }

    public PointStoreSmall(PointStore.Builder builder) {
        super(builder);
        CommonUtils.checkArgument(this.shingleSize * this.capacity < 65535, " incorrect parameters");
        if (builder.locationList != null) {
            this.locationList = new char[builder.locationList.length];
            for (int i = 0; i < this.locationList.length; ++i) {
                this.locationList[i] = (char)builder.locationList[i];
            }
        } else {
            this.locationList = new char[this.currentStoreCapacity];
            Arrays.fill(this.locationList, INFEASIBLE_SMALL_POINTSTORE_LOCN);
        }
    }

    public PointStoreSmall(int dimensions, int capacity) {
        this((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)((PointStore.Builder)PointStore.builder().capacity(capacity)).dimensions(dimensions)).shingleSize(1)).initialSize(capacity));
    }

    @Override
    protected void checkFeasible(int index) {
        CommonUtils.checkArgument(this.locationList[index] != INFEASIBLE_SMALL_POINTSTORE_LOCN, " invalid point");
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < this.locationList.length; ++i) {
            if (this.locationList[i] == INFEASIBLE_SMALL_POINTSTORE_LOCN) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int[] getLocationList() {
        int[] answer = new int[this.locationList.length];
        for (int i = 0; i < this.locationList.length; ++i) {
            answer[i] = this.locationList[i];
        }
        return answer;
    }
}

