/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Map;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.StatefulSearchResponseProcessor;
import org.opensearch.search.pipeline.common.helpers.ContextUtils;
import org.opensearch.search.pipeline.common.helpers.SearchResponseUtil;

public class TruncateHitsResponseProcessor
extends AbstractProcessor
implements StatefulSearchResponseProcessor {
    public static final String TYPE = "truncate_hits";
    static final String TARGET_SIZE = "target_size";
    private final int targetSize;
    private final String contextPrefix;

    public String getType() {
        return TYPE;
    }

    private TruncateHitsResponseProcessor(String tag, String description, boolean ignoreFailure, int targetSize, String contextPrefix) {
        super(tag, description, ignoreFailure);
        this.targetSize = targetSize;
        this.contextPrefix = contextPrefix;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response, PipelineProcessingContext requestContext) {
        int size;
        if (this.targetSize < 0) {
            String key = ContextUtils.applyContextPrefix(this.contextPrefix, "original_size");
            Object o = requestContext.getAttribute(key);
            if (o == null) {
                throw new IllegalStateException("Must specify target_size unless an earlier processor set " + key);
            }
            size = (Integer)o;
        } else {
            size = this.targetSize;
        }
        if (response.getHits() != null && response.getHits().getHits().length > size) {
            SearchHit[] newHits = new SearchHit[size];
            System.arraycopy(response.getHits().getHits(), 0, newHits, 0, size);
            return SearchResponseUtil.replaceHits(newHits, response);
        }
        return response;
    }

    static class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        Factory() {
        }

        public TruncateHitsResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            Integer targetSize = ConfigurationUtils.readIntProperty((String)TruncateHitsResponseProcessor.TYPE, (String)tag, config, (String)TruncateHitsResponseProcessor.TARGET_SIZE, null);
            if (targetSize == null) {
                targetSize = -1;
            } else if (targetSize < 0) {
                throw ConfigurationUtils.newConfigurationException((String)TruncateHitsResponseProcessor.TYPE, (String)tag, (String)TruncateHitsResponseProcessor.TARGET_SIZE, (String)"Value must be >= 0");
            }
            String contextPrefix = ConfigurationUtils.readOptionalStringProperty((String)TruncateHitsResponseProcessor.TYPE, (String)tag, config, (String)"context_prefix");
            return new TruncateHitsResponseProcessor(tag, description, ignoreFailure, targetSize, contextPrefix);
        }
    }
}

