/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.compress.NotCompressedException;
import org.opensearch.core.compress.NotXContentException;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.transport.grpc.util.RestToGrpcStatusConverter;

public class GrpcErrorHandler {
    private static final Logger logger = LogManager.getLogger(GrpcErrorHandler.class);

    private GrpcErrorHandler() {
    }

    public static StatusRuntimeException convertToGrpcError(Exception e) {
        Exception exception = e;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{OpenSearchException.class, OpenSearchRejectedExecutionException.class, NotXContentException.class, NotCompressedException.class, InputCoercionException.class, JsonParseException.class, IllegalArgumentException.class, IllegalStateException.class, SecurityException.class, TimeoutException.class, InterruptedException.class, IOException.class}, (Object)exception, n)) {
            case 0: {
                OpenSearchException ose = (OpenSearchException)exception;
                return GrpcErrorHandler.handleOpenSearchException(ose);
            }
            case 1: {
                OpenSearchRejectedExecutionException osree = (OpenSearchRejectedExecutionException)exception;
                return Status.RESOURCE_EXHAUSTED.withDescription(ExceptionsHelper.stackTrace((Throwable)osree)).asRuntimeException();
            }
            case 2: {
                NotXContentException notXContentException = (NotXContentException)exception;
                return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)notXContentException)).asRuntimeException();
            }
            case 3: {
                NotCompressedException notCompressedException = (NotCompressedException)exception;
                return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)notCompressedException)).asRuntimeException();
            }
            case 4: {
                InputCoercionException inputCoercionException = (InputCoercionException)exception;
                return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)inputCoercionException)).asRuntimeException();
            }
            case 5: {
                JsonParseException jsonParseException = (JsonParseException)exception;
                return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)jsonParseException)).asRuntimeException();
            }
            case 6: {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)exception;
                return Status.INVALID_ARGUMENT.withDescription(ExceptionsHelper.stackTrace((Throwable)illegalArgumentException)).asRuntimeException();
            }
            case 7: {
                IllegalStateException illegalStateException = (IllegalStateException)exception;
                return Status.FAILED_PRECONDITION.withDescription(ExceptionsHelper.stackTrace((Throwable)illegalStateException)).asRuntimeException();
            }
            case 8: {
                SecurityException securityException = (SecurityException)exception;
                return Status.PERMISSION_DENIED.withDescription(ExceptionsHelper.stackTrace((Throwable)securityException)).asRuntimeException();
            }
            case 9: {
                TimeoutException timeoutException = (TimeoutException)exception;
                return Status.DEADLINE_EXCEEDED.withDescription(ExceptionsHelper.stackTrace((Throwable)timeoutException)).asRuntimeException();
            }
            case 10: {
                InterruptedException interruptedException = (InterruptedException)exception;
                return Status.CANCELLED.withDescription(ExceptionsHelper.stackTrace((Throwable)interruptedException)).asRuntimeException();
            }
            case 11: {
                IOException ioException = (IOException)exception;
                return Status.INTERNAL.withDescription(ExceptionsHelper.stackTrace((Throwable)ioException)).asRuntimeException();
            }
            case -1: {
                logger.warn("Unexpected null exception type, treating as INTERNAL error");
                return Status.INTERNAL.withDescription("Unexpected null exception").asRuntimeException();
            }
        }
        logger.warn("Unmapped exception type: {}, treating as INTERNAL error", (Object)e.getClass().getSimpleName());
        return Status.INTERNAL.withDescription(ExceptionsHelper.stackTrace((Throwable)e)).asRuntimeException();
    }

    private static StatusRuntimeException handleOpenSearchException(OpenSearchException ose) {
        Status grpcStatus = RestToGrpcStatusConverter.convertRestToGrpcStatus(ose.status());
        Throwable unwrapped = ExceptionsHelper.unwrapToOpenSearchException((Throwable)ose);
        String baseDescription = ExceptionsHelper.summaryMessage((Throwable)unwrapped);
        String enhancedDescription = GrpcErrorHandler.enhanceDescriptionWithXContentMetadata(unwrapped, baseDescription);
        return grpcStatus.withDescription(enhancedDescription).asRuntimeException();
    }

    private static String enhanceDescriptionWithXContentMetadata(Throwable exception, String baseDescription) {
        String string;
        block8: {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            try {
                builder.startObject();
                OpenSearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Exception)((Exception)exception), (boolean)true);
                RestStatus restStatus = ExceptionsHelper.status((Throwable)((Exception)exception));
                builder.field("status", restStatus.getStatus());
                builder.endObject();
                String jsonString = builder.toString();
                logger.debug("gRPC error details: {}", (Object)jsonString);
                string = baseDescription + "; details=" + jsonString;
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Failed to extract XContent metadata for exception: " + e.getMessage());
                    return baseDescription;
                }
            }
            builder.close();
        }
        return string;
    }
}

