/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.cluster.metadata.CryptoMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.common.blobstore.InputStreamWithMetadata;

public abstract class FilterBlobContainer
implements BlobContainer {
    private final BlobContainer delegate;

    public FilterBlobContainer(BlobContainer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected abstract BlobContainer wrapChild(BlobContainer var1);

    @Override
    public BlobPath path() {
        return this.delegate.path();
    }

    @Override
    public boolean blobExists(String blobName) throws IOException {
        return this.delegate.blobExists(blobName);
    }

    @Override
    public InputStream readBlob(String blobName) throws IOException {
        return this.delegate.readBlob(blobName);
    }

    @Override
    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        return this.delegate.readBlob(blobName, position, length);
    }

    @Override
    public long readBlobPreferredLength() {
        return this.delegate.readBlobPreferredLength();
    }

    @Override
    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    @Override
    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlobAtomic(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    @Override
    public InputStreamWithMetadata readBlobWithMetadata(String blobName) throws IOException {
        return this.delegate.readBlobWithMetadata(blobName);
    }

    @Override
    public void writeBlobWithMetadata(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists, @Nullable Map<String, String> metadata) throws IOException {
        this.delegate.writeBlobWithMetadata(blobName, inputStream, blobSize, failIfAlreadyExists, metadata);
    }

    @Override
    public void writeBlobWithMetadata(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists, @Nullable Map<String, String> metadata, @Nullable CryptoMetadata cryptoMetadata) throws IOException {
        this.delegate.writeBlobWithMetadata(blobName, inputStream, blobSize, failIfAlreadyExists, metadata, cryptoMetadata);
    }

    @Override
    public void writeBlobAtomicWithMetadata(String blobName, InputStream inputStream, @Nullable Map<String, String> metadata, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlobAtomicWithMetadata(blobName, inputStream, metadata, blobSize, failIfAlreadyExists);
    }

    @Override
    public DeleteResult delete() throws IOException {
        return this.delegate.delete();
    }

    @Override
    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        this.delegate.deleteBlobsIgnoringIfNotExists(blobNames);
    }

    @Override
    public Map<String, BlobMetadata> listBlobs() throws IOException {
        return this.delegate.listBlobs();
    }

    @Override
    public Map<String, BlobContainer> children() throws IOException {
        return this.delegate.children().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.wrapChild((BlobContainer)e.getValue())));
    }

    @Override
    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        return this.delegate.listBlobsByPrefix(blobNamePrefix);
    }
}

