/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public record StandardAcl(ResourceType resourceType, String resourceName, PatternType patternType, String principal, String host, AclOperation operation, AclPermissionType permissionType) implements Comparable<StandardAcl>
{
    public static StandardAcl fromRecord(AccessControlEntryRecord record) {
        return new StandardAcl(ResourceType.fromCode((byte)record.resourceType()), record.resourceName(), PatternType.fromCode((byte)record.patternType()), record.principal(), record.host(), AclOperation.fromCode((byte)record.operation()), AclPermissionType.fromCode((byte)record.permissionType()));
    }

    public static StandardAcl fromAclBinding(AclBinding acl) {
        return new StandardAcl(acl.pattern().resourceType(), acl.pattern().name(), acl.pattern().patternType(), acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
    }

    public KafkaPrincipal kafkaPrincipal() {
        int colonIndex = this.principal.indexOf(":");
        if (colonIndex == -1) {
            throw new IllegalStateException("Could not parse principal from `" + this.principal + "` (no colon is present separating the principal type from the principal name)");
        }
        String principalType = this.principal.substring(0, colonIndex);
        String principalName = this.principal.substring(colonIndex + 1);
        return new KafkaPrincipal(principalType, principalName);
    }

    public AclBinding toBinding() {
        ResourcePattern resourcePattern = new ResourcePattern(this.resourceType, this.resourceName, this.patternType);
        AccessControlEntry accessControlEntry = new AccessControlEntry(this.principal, this.host, this.operation, this.permissionType);
        return new AclBinding(resourcePattern, accessControlEntry);
    }

    @Override
    public int compareTo(StandardAcl other) {
        int result = this.resourceType.compareTo((Enum)other.resourceType);
        if (result != 0) {
            return result;
        }
        result = other.resourceName.compareTo(this.resourceName);
        if (result != 0) {
            return result;
        }
        result = this.patternType.compareTo((Enum)other.patternType);
        if (result != 0) {
            return result;
        }
        result = this.operation.compareTo((Enum)other.operation);
        if (result != 0) {
            return result;
        }
        result = this.principal.compareTo(other.principal);
        if (result != 0) {
            return result;
        }
        result = this.host.compareTo(other.host);
        if (result != 0) {
            return result;
        }
        result = this.permissionType.compareTo((Enum)other.permissionType);
        return result;
    }
}

