/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.util.DynamicStats;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.util.Time;
import org.jetbrains.kotlin.util.UnitStats;
import org.jetbrains.kotlin.util.UnitStatsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"reportPerformanceData", "", "Lorg/jetbrains/kotlin/build/report/BuildReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "moduleStats", "Lorg/jetbrains/kotlin/util/UnitStats;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\ncompilerPerformanceReporting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compilerPerformanceReporting.kt\norg/jetbrains/kotlin/build/report/CompilerPerformanceReportingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n774#2:61\n865#2,2:62\n1869#2,2:64\n*S KotlinDebug\n*F\n+ 1 compilerPerformanceReporting.kt\norg/jetbrains/kotlin/build/report/CompilerPerformanceReportingKt\n*L\n47#1:61\n47#1:62,2\n47#1:64,2\n*E\n"})
public final class CompilerPerformanceReportingKt {
    public static final void reportPerformanceData(@NotNull BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> $this$reportPerformanceData, @NotNull UnitStats moduleStats) {
        Intrinsics.checkNotNullParameter($this$reportPerformanceData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)moduleStats, (String)"moduleStats");
        if (moduleStats.getLinesCount() > 0) {
            $this$reportPerformanceData.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)GradleBuildPerformanceMetric.SOURCE_LINES_NUMBER), moduleStats.getLinesCount());
        }
        Ref.ObjectRef codegenTime = new Ref.ObjectRef();
        codegenTime.element = Time.Companion.getZERO();
        UnitStatsKt.forEachPhaseMeasurement(moduleStats, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> CompilerPerformanceReportingKt.reportPerformanceData$lambda$0(codegenTime, $this$reportPerformanceData, moduleStats, arg_0, arg_1)));
        if (!Intrinsics.areEqual((Object)codegenTime.element, (Object)Time.Companion.getZERO())) {
            $this$reportPerformanceData.addTimeMetricNs((GradleBuildTime)((BuildTime)GradleBuildTime.CODE_GENERATION), ((Time)codegenTime.element).getNanos());
            CompilerPerformanceReportingKt.reportPerformanceData$reportLps($this$reportPerformanceData, moduleStats, GradleBuildPerformanceMetric.CODE_GENERATION_LPS, (Time)codegenTime.element);
        }
    }

    private static final void reportPerformanceData$reportLps(BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> $this_reportPerformanceData, UnitStats $moduleStats, GradleBuildPerformanceMetric lpsMetrics, Time time) {
        if (!Intrinsics.areEqual((Object)time, (Object)Time.Companion.getZERO())) {
            $this_reportPerformanceData.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)lpsMetrics), (long)UnitStatsKt.getLinesPerSecond($moduleStats, time));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit reportPerformanceData$lambda$0(Ref.ObjectRef $codegenTime, BuildReporter $this_reportPerformanceData, UnitStats $moduleStats, PhaseType phaseType, Time time) {
        GradleBuildTime gradleBuildTime;
        Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
        if (time == null) {
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[phaseType.ordinal()]) {
            case 1: {
                gradleBuildTime = GradleBuildTime.COMPILER_INITIALIZATION;
                break;
            }
            case 2: {
                gradleBuildTime = GradleBuildTime.CODE_ANALYSIS;
                break;
            }
            case 3: {
                gradleBuildTime = GradleBuildTime.TRANSLATION_TO_IR;
                break;
            }
            case 4: {
                gradleBuildTime = GradleBuildTime.IR_PRE_LOWERING;
                break;
            }
            case 5: {
                gradleBuildTime = GradleBuildTime.IR_SERIALIZATION;
                break;
            }
            case 6: {
                gradleBuildTime = GradleBuildTime.KLIB_WRITING;
                break;
            }
            case 7: {
                $codegenTime.element = ((Time)$codegenTime.element).plus(time);
                gradleBuildTime = GradleBuildTime.IR_LOWERING;
                break;
            }
            case 8: {
                $codegenTime.element = ((Time)$codegenTime.element).plus(time);
                gradleBuildTime = GradleBuildTime.BACKEND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GradleBuildTime gradleBuildTime2 = gradleBuildTime;
        $this_reportPerformanceData.addTimeMetricNs((BuildTime)gradleBuildTime2, time.getNanos());
        List<DynamicStats> list = $moduleStats.getDynamicStats();
        if (list != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DynamicStats it = (DynamicStats)element$iv$iv;
                boolean bl = false;
                if (!(it.getParentPhaseType() == phaseType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DynamicStats dynamicStats = (DynamicStats)element$iv;
                boolean bl = false;
                String name2 = dynamicStats.component2();
                Time time2 = dynamicStats.component3();
                $this_reportPerformanceData.addDynamicTimeMetricNs(name2, (BuildTime)gradleBuildTime2, time2.getNanos());
            }
        }
        if (phaseType == PhaseType.Analysis) {
            CompilerPerformanceReportingKt.reportPerformanceData$reportLps($this_reportPerformanceData, $moduleStats, GradleBuildPerformanceMetric.ANALYSIS_LPS, time);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PhaseType.values().length];
            try {
                nArray[PhaseType.Initialization.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Analysis.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.TranslationToIr.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrPreLowering.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrSerialization.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.KlibWriting.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrLowering.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Backend.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

