/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal;

import com.google.common.base.Optional;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.plugins.ide.IdeWorkspace;
import org.gradle.process.ExecOperations;

public abstract class IdePlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(IdePlugin.class);
    private TaskProvider<Task> lifecycleTask;
    private TaskProvider<Delete> cleanTask;
    protected Project project;

    @Inject
    protected abstract ExecOperations getExecOperations();

    public static String toGradleCommand(Project project) {
        Gradle gradle = project.getGradle();
        Optional gradleWrapperPath = Optional.absent();
        Project rootProject = project.getRootProject();
        String gradlewExtension = OperatingSystem.current().isWindows() ? ".bat" : "";
        File gradlewFile = rootProject.file((Object)("gradlew" + gradlewExtension));
        if (gradlewFile.exists()) {
            gradleWrapperPath = Optional.of((Object)gradlewFile.getAbsolutePath());
        }
        if (gradle.getGradleHomeDir() != null) {
            if (gradleWrapperPath.isPresent() && gradle.getGradleHomeDir().getAbsolutePath().startsWith(gradle.getGradleUserHomeDir().getAbsolutePath())) {
                return (String)gradleWrapperPath.get();
            }
            return gradle.getGradleHomeDir().getAbsolutePath() + "/bin/gradle";
        }
        return (String)gradleWrapperPath.or((Object)"gradle");
    }

    public void apply(Project target) {
        this.project = target;
        String lifecycleTaskName = this.getLifecycleTaskName();
        this.lifecycleTask = target.getTasks().register(lifecycleTaskName);
        this.cleanTask = target.getTasks().register(this.cleanName(lifecycleTaskName), Delete.class, (Action)new Action<Delete>(){

            public void execute(Delete task) {
                task.setGroup("IDE");
            }
        });
        this.lifecycleTask.configure((Action)new Action<Task>(){

            public void execute(Task task) {
                task.setGroup("IDE");
                task.shouldRunAfter(new Object[]{IdePlugin.this.cleanTask});
            }
        });
        this.onApply(target);
    }

    public TaskProvider<? extends Task> getLifecycleTask() {
        return this.lifecycleTask;
    }

    public TaskProvider<? extends Task> getCleanTask() {
        return this.cleanTask;
    }

    protected String cleanName(String taskName) {
        return String.format("clean%s", StringUtils.capitalize((String)taskName));
    }

    public void addWorker(Task worker) {
        this.addWorker((TaskProvider<? extends Task>)this.project.getTasks().named(worker.getName()), worker.getName());
    }

    public void addWorker(TaskProvider<? extends Task> worker, String workerName) {
        this.addWorker(worker, workerName, true);
    }

    public void addWorker(Task worker, boolean includeInClean) {
        this.addWorker((TaskProvider<? extends Task>)this.project.getTasks().named(worker.getName()), worker.getName(), includeInClean);
    }

    public void addWorker(final TaskProvider<? extends Task> worker, String workerName, boolean includeInClean) {
        this.lifecycleTask.configure(IdePlugin.dependsOn(worker));
        final TaskProvider cleanWorker = this.project.getTasks().register(this.cleanName(workerName), Delete.class, (Action)new Action<Delete>(){

            public void execute(Delete cleanWorker) {
                cleanWorker.delete(new Object[]{worker});
            }
        });
        if (includeInClean) {
            this.cleanTask.configure(IdePlugin.dependsOn((TaskProvider<? extends Task>)cleanWorker));
        }
        worker.configure((Action)new Action<Task>(){

            public void execute(Task task) {
                task.shouldRunAfter(new Object[]{cleanWorker});
            }
        });
    }

    protected static Action<? super Task> dependsOn(final Task taskDependency) {
        return new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{taskDependency});
            }
        };
    }

    protected static Action<? super Task> dependsOn(final TaskProvider<? extends Task> taskProvider) {
        return new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{taskProvider});
            }
        };
    }

    protected static Action<? super Task> withDescription(final String description) {
        return new Action<Task>(){

            public void execute(Task task) {
                task.setDescription(description);
            }
        };
    }

    protected void onApply(Project target) {
    }

    protected void addWorkspace(final IdeWorkspace workspace) {
        this.lifecycleTask.configure((Action)new Action<Task>(){

            public void execute(Task lifecycleTask) {
                String displayName = workspace.getDisplayName();
                Provider location = workspace.getLocation();
                lifecycleTask.doLast(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)t -> LOGGER.lifecycle(String.format("Generated %s at %s", displayName, new ConsoleRenderer().asClickableFileUrl(((FileSystemLocation)location.get()).getAsFile())))));
            }
        });
        this.project.getTasks().register("open" + StringUtils.capitalize((String)this.getLifecycleTaskName()), (Action)new Action<Task>(){

            public void execute(Task openTask) {
                openTask.dependsOn(new Object[]{IdePlugin.this.lifecycleTask});
                openTask.setGroup("IDE");
                openTask.setDescription("Opens the " + workspace.getDisplayName());
                final ExecOperations execOperations = IdePlugin.this.getExecOperations();
                openTask.doLast((Action)new Action<Task>(){

                    public void execute(Task task) {
                        if (OperatingSystem.current().isMacOsX()) {
                            execOperations.exec(execSpec -> execSpec.commandLine(new Object[]{"open", workspace.getLocation().get()}));
                        } else {
                            try {
                                Desktop.getDesktop().open(((FileSystemLocation)workspace.getLocation().get()).getAsFile());
                            }
                            catch (IOException e) {
                                throw UncheckedException.throwAsUncheckedException((Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }

    protected abstract String getLifecycleTaskName();

    public boolean isRoot() {
        return this.project.getParent() == null;
    }
}

