/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.internal.UncheckedException;

public class GitIgnoreGenerator
implements BuildContentGenerator {
    @Override
    public void generate(InitSettings settings, BuildContentGenerationContext buildContentGenerationContext) {
        File file = settings.getTarget().file(".gitignore").getAsFile();
        Set<String> gitignoresToAppend = GitIgnoreGenerator.getGitignoresToAppend(file);
        if (!gitignoresToAppend.isEmpty()) {
            boolean shouldAppendNewLine = file.exists();
            try (PrintWriter writer = new PrintWriter(new FileWriter(file, true));){
                Spliterator<String> it;
                if (shouldAppendNewLine) {
                    writer.println();
                }
                if ((it = gitignoresToAppend.spliterator()).tryAdvance(e -> GitIgnoreGenerator.withComment(e).forEach(writer::println))) {
                    StreamSupport.stream(it, false).forEach(e -> GitIgnoreGenerator.withSeparator(GitIgnoreGenerator.withComment(e)).forEach(writer::println));
                }
            }
            catch (IOException e2) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e2);
            }
        }
    }

    private static Set<String> getGitignoresToAppend(File gitignoreFile) {
        LinkedHashSet result = Sets.newLinkedHashSet(Arrays.asList(".gradle", "build"));
        if (gitignoreFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(gitignoreFile));){
                result.removeAll(reader.lines().filter(it -> result.contains(it)).collect(Collectors.toSet()));
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return result;
    }

    private static List<String> withComment(String entry) {
        ArrayList<String> result = new ArrayList<String>();
        if (entry.startsWith(".gradle")) {
            result.add("# Ignore Gradle project-specific cache directory");
        } else if (entry.startsWith("build")) {
            result.add("# Ignore Gradle build output directory");
        }
        result.add(entry);
        return result;
    }

    private static List<String> withSeparator(List<String> entry) {
        ArrayList<String> result = new ArrayList<String>(1 + entry.size());
        result.add("");
        result.addAll(entry);
        return result;
    }
}

