############################ Copyrights and license ############################
#                                                                              #
# Copyright 2025 Enrico Minack <github@enrico.minack.dev>                      #
# Copyright 2025 Matt Ball <96152357+mball-agathos@users.noreply.github.com>   #
#                                                                              #
# This file is part of PyGithub.                                               #
# http://pygithub.readthedocs.io/                                              #
#                                                                              #
# PyGithub is free software: you can redistribute it and/or modify it under    #
# the terms of the GNU Lesser General Public License as published by the Free  #
# Software Foundation, either version 3 of the License, or (at your option)    #
# any later version.                                                           #
#                                                                              #
# PyGithub is distributed in the hope that it will be useful, but WITHOUT ANY  #
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS    #
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more #
# details.                                                                     #
#                                                                              #
# You should have received a copy of the GNU Lesser General Public License     #
# along with PyGithub. If not, see <http://www.gnu.org/licenses/>.             #
#                                                                              #
################################################################################

from __future__ import annotations

from typing import Any

from github.GithubObject import (
    Attribute,
    NonCompletableGithubObject,
    NotSet,
)


class GeneratedReleaseNotes(NonCompletableGithubObject):
    """
    This class represents the release notes generated by the release/generate-notes REST API endpoint.

    The reference can be found here:
    https://docs.github.com/en/rest/releases/releases#generate-release-notes-content-for-a-release

    The OpenAPI schema can be found at

    - /components/schemas/release-notes-content

    """

    def _initAttributes(self) -> None:
        self._body: Attribute[str] = NotSet
        self._name: Attribute[str] = NotSet

    def __repr__(self) -> str:
        return self.get__repr__({"name": self._name.value, "body": self._body.value})

    @property
    def body(self) -> str:
        return self._body.value

    @property
    def name(self) -> str:
        return self._name.value

    def _useAttributes(self, attributes: dict[str, Any]) -> None:
        if "body" in attributes:
            self._body = self._makeStringAttribute(attributes["body"])
        if "name" in attributes:
            self._name = self._makeStringAttribute(attributes["name"])
