'''OpenGL extension INTEL.conservative_rasterization

This module customises the behaviour of the 
OpenGL.raw.GL.INTEL.conservative_rasterization to provide a more 
Python-friendly API

Overview (from the spec)
	
	Regular rasterization includes fragments with at least one
	sample covered by a polygon. Conservative rasterization includes all
	fragments that are at least partially covered by the polygon.
	
	In some use cases, it is also important to know if a fragment is fully
	covered by a polygon, i.e. if all parts of the fragment are within the
	polygon. An application may, for example, want to process fully covered
	fragments different from the "edge" pixels. This extension adds an option
	for the fragment shader to receive this information via gl_SampleMaskIn[].
	
	This extension affects only polygons in FILL mode and specifically does not
	imply any changes in processing of lines or points.
	
	Conservative rasterization automatically disables polygon antialiasing
	rasterization if enabled by POLYGON_SMOOTH.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/INTEL/conservative_rasterization.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.INTEL.conservative_rasterization import *
from OpenGL.raw.GL.INTEL.conservative_rasterization import _EXTENSION_NAME

def glInitConservativeRasterizationINTEL():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION