'''OpenGL extension AMD.framebuffer_sample_positions

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.framebuffer_sample_positions to provide a more 
Python-friendly API

Overview (from the spec)
	
	In unextended GL, the sub-pixel loations of multisampled textures and
	renderbuffers are generally determined in an implementation dependent
	manner. Some algorithms -- in particular custom antialiasing functions --
	depend on the knowledge of, or even require control over the positions of
	samples within each pixel.
	
	The AMD_sample_positions extension added some control over the positions
	of samples within a single framebuffer. However, it forced all pixels
	within a framebuffer to have the set of sample positions.
	
	This extension provides a mechanism to explicitly set sample positions for
	a framebuffer object with multi-sampled attachments in a repeating pattern,
	allowing different pixels to use different sub-pixel locations for their
	samples. The sample locations used by the FBO can be fixed for all pixels
	in the FBOs attachments or they can be fixed for a sampling pattern
	comprised of multiple pixels, where the sampling pattern is repeated over
	all pixels. The rate of repeat of this sampling pattern size itself is
	fixed and is implementation-dependent.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/framebuffer_sample_positions.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.framebuffer_sample_positions import *
from OpenGL.raw.GL.AMD.framebuffer_sample_positions import _EXTENSION_NAME

def glInitFramebufferSamplePositionsAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION