from collections import OrderedDict

from .. import Provider as ColorProvider

localized = True


class Provider(ColorProvider):
    """
    Implement color provider for ``el_GR`` locale.
    Naming and hex codes are based on https://encycolorpedia.gr/named
    """

    all_colors = OrderedDict(
        (
            ("άσιντ πράσινο", "#B0BF1A"),
            ("άσπρο", "#FFFFFF"),
            ("άστριοι", "#FDD5B1"),
            ("αβοκάντο", "#568203"),
            ("αγκινάρα", "#8F9779"),
            ("αζούρ", "#8AB9F1"),
            ("ακαζού", "#4C2F27"),
            ("ασημένιο", "#C0C0C0"),
            ("βαθύ κόκκινο", "#850101"),
            ("βερικοκί", "#FBCEB1"),
            ("βερμιγιόν", "#E34234"),
            ("βιολετί", "#7F00FF"),
            ("βρύο", "#8A9A5B"),
            ("βυσσινί", "#DC143C"),
            ("γαλάζιο", "#ADD8E6"),
            ("γκρι", "#808080"),
            ("γλαυκό", "#6082B6"),
            ("εκρού", "#C2B280"),
            ("ιβουάρ", "#FFFFF0"),
            ("ινδικό", "#4B0082"),
            ("κίτρινο", "#9B870C"),
            ("καμηλό", "#C19A6B"),
            ("κανέλα", "#D2691E"),
            ("καστανέρυθρο", "#8B0000"),
            ("καστανό", "#954535"),
            ("καφέ", "#A52A2A"),
            ("καφές", "#6F4E37"),
            ("κυανό", "#800080"),
            ("κεχριμπάρι", "#FFBF00"),
            ("κόκκινο", "#FF0000"),
            ("λάβα", "#CF1020"),
            ("λαδί", "#3B3C36"),
            ("λευκό", "#DBE9F4"),
            ("μαρόν", "#800000"),
            ("ματζέντα", "#CC00CC"),
            ("μαόνι", "#CD4A4C"),
            ("μαύρο", "#000000"),
            ("μπέιμπι μπλου", "#89CFF0"),
            ("μπεζ", "#F5F5DC"),
            ("μπλε", "#0000FF"),
            ("μπλε μαρέν", "#1974D2"),
            ("μπορντό", "#7F1734"),
            ("μπουργκουντί", "#900020"),
            ("μυρτιά", "#317873"),
            ("μωβ", "#B19CD9"),
            ("ορείχαλκος", "#B5A642"),
            ("πέρλα", "#EAE0C8"),
            ("πεύκο", "#01796F"),
            ("πλατίνα", "#E5E4E2"),
            ("πορτοκαλί", "#FF7F00"),
            ("πορτοκαλοκίτρινο", "#DAA520"),
            ("πράσινο", "#000FF0"),
            ("πράσινο chartreuse", "#7FFF00"),
            ("πράσινο αγκινάρας", "#4B6F44"),
            ("πράσινο ανοιχτό", "#90EE90"),
            ("πράσινο ζούγκλας", "#29AB87"),
            ("πράσινο λαουρέλ", "#A9BA9D"),
            ("πράσινο σκούρο", "#013220"),
            ("πράσινο της άνοιξης", "#00FF7F"),
            ("πράσινο της μέντας", "#98FB98"),
            ("πράσινο της φτέρης", "#4F7942"),
            ("πράσινο του δάσους", "#228B22"),
            ("πράσινο τσάι", "#D0F0C0"),
            ("πράσινο χούκερ", "#49796B"),
            ("ραφ", "#5D8AA8"),
            ("ροζ", "#FFC0CB"),
            ("ροζέ", "#FF007F"),
            ("σέπια", "#704214"),
            ("σαμπανιζέ", "#F7E7CE"),
            ("σκάρλετ", "#FF2400"),
            ("σκούρο βρύο", "#4A5D23"),
            ("σπαραγγί", "#87A96B"),
            ("ταν", "#D2B48C"),
            ("φλαμίνγκο", "#FC8EAC"),
            ("φούξια", "#F400A1"),
            ("φτέρη", "#71BC78"),
            ("χλωροφύλλη", "#4AFF00"),
            ("χρυσαφένιο", "#FFD700"),
            ("χρυσό", "#808000"),
            ("ώχρα", "#E97451"),
        )
    )

    safe_colors = (
        "μαύρο",
        "πράσινο",
        "μπλε",
        "κίτρινο",
        "κόκκινο",
        "μωβ",
        "άσπρο",
        "γκρι",
        "ασημένιο",
        "καφέ",
        "λαδί",
        "χρυσό",
        "ροζ",
    )
