/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.Argument;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.common.ValenceParser;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.Articles;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.PrepositionIssues;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GermanValences {
    static final Argument DASS = new Argument("dass", NodePattern.or(NodePattern.N.withHeadRelation("ccomp"), GermanTreePatterns.whPhrase.withHeadRelation("advmod"))){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument ES = new Argument("es", NodePattern.N.form("es")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DAVON = new Argument("davon", NodePattern.N.form("davon")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DAMIT = new Argument("damit", NodePattern.N.form("damit")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DARUM = new Argument("darum", NodePattern.N.form("darum")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DARIN = new Argument("darin", NodePattern.N.form("darin")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DARAUF = new Argument("darauf", NodePattern.N.form("darauf")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DARAN = new Argument("daran", NodePattern.N.form("daran")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument DARUNTER = new Argument("darunter", NodePattern.N.form("darunter")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument ZU_INF = new Argument("zuInf", NodePattern.N.withHeadRelation("xcomp").pos("VER:(INF|EIZ).*")){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument ADJ_PRD = new Argument("adjPrd", NodePattern.N.withHeadRelation("xcomp").pos("ADJ:PRD:.*").noDependents()){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument SMALL_CLAUSE = new Argument("smallClause", NodePattern.N.withHeadRelation("xcomp").withDependent("nsubj|obj|nmod", NodePattern.N.noDependents("case"))){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument REFL = new Argument("refl", ReflexivePronouns.accReflexivPronomen){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument D_REFL = new Argument("DRefl", ReflexivePronouns.datReflexivPronomen){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final NodePattern ort = NodePattern.or(PrepositionIssues.geo.andOr(NodePattern.N.pos("EIG.*"), Articles.countryFeminineArticle, Articles.countryPluralArticle, NodePattern.N.withDependent("flat", PrepositionIssues.geo.directlyAfterHead())), NodePattern.N.lemma("Wohnung|Urlaub|Stadt|Haus|Appartement|Hotel").noDependents("conj"));
    static final Argument AUS_D_ORT = new Argument("ausD:Ort", ort){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument NACH_A_ORT = new Argument("nachA:Ort", ort){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    static final Argument IN_A_ORT = new Argument("inA:Ort", ort){

        @Override
        public boolean isObligatory() {
            return true;
        }
    };
    private static final ValenceParser parser = new ValenceParser(new Argument[]{DASS, ES, DAMIT, DAVON, DARAUF, DARUM, DARIN, DARAN, DARUNTER, ZU_INF, ADJ_PRD, SMALL_CLAUSE, REFL, D_REFL, AUS_D_ORT, NACH_A_ORT, IN_A_ORT}){

        @Override
        public Argument arg(String arg) {
            Case caze;
            String animacyStr;
            String string = animacyStr = arg.contains(":") ? arg.substring(arg.indexOf(":")) : null;
            AnimacyStatus animacy = animacyStr == null ? AnimacyStatus.NOT_STATED : (animacyStr.equals(":Anim") ? AnimacyStatus.ANIMATE : AnimacyStatus.INANIMATE);
            String prepCaseStr = arg.contains(":") ? arg.substring(0, arg.indexOf(":")) : arg;
            char last = prepCaseStr.charAt(prepCaseStr.length() - 1);
            Case case_ = last == 'N' ? Case.NOM : (last == 'G' ? Case.GEN : (last == 'D' ? Case.DAT : (caze = last == 'A' ? Case.AKK : null)));
            if (caze == null) {
                throw new IllegalArgumentException("Can't parse " + arg);
            }
            return new NominalArgument(arg, prepCaseStr.length() == 1 ? null : prepCaseStr.substring(0, prepCaseStr.length() - 1), caze, animacy);
        }
    };
    private static final Map<String, List<Valence>> verbValences = parser.fromResource("de/verb_arg_structures.txt");
    private static final NodePattern withNomSubject = NodePattern.or(GermanTreePatterns.finiteVerb, GermanTreePatterns.infinitive.withDependent("cop|aux.*", GermanTreePatterns.finiteVerb));

    GermanValences() {
    }

    @NotNull
    static List<Valence> get(Node node) {
        LinkedHashSet<Valence> result = new LinkedHashSet<Valence>();
        Node particle = node.findSingleDependent("compound:prt");
        String prefix = particle == null ? "" : GermanValences.normalizeUmlauts(particle.lowForm());
        for (Tree.Reading reading : node.tokenReadings()) {
            String pos = reading.pos();
            if (pos == null) {
                return List.of();
            }
            if (!pos.startsWith("VER")) continue;
            List<Valence> valences = verbValences.get(prefix + reading.lemma());
            if (valences == null) {
                return List.of();
            }
            boolean addNomSubj = withNomSubject.matches(node);
            for (Valence structure : valences) {
                if (addNomSubj) {
                    structure = structure.append(NominalArgument.NOM);
                }
                result.add(structure);
            }
            result.addAll(valences);
        }
        return new ArrayList<Valence>(result);
    }

    static String normalizePreposition(Node prep) {
        String defused = prep.lowForm();
        if (AdjDeclination.anyFusedPreposition.matches(prep)) {
            defused = switch (defused) {
                case "am" -> "an";
                case "vom" -> "von";
                case "im" -> "in";
                default -> defused.substring(0, defused.length() - 1);
            };
        }
        return GermanValences.normalizeUmlauts(defused);
    }

    private static String normalizeUmlauts(String prep) {
        return prep.replaceAll("ae", "\u00e4").replaceAll("oe", "\u00f6").replaceAll("ue", "\u00fc");
    }

    static class NominalArgument
    extends Argument {
        private static final Argument NOM = parser.arg("N");
        private static final NodePattern oblExplPv = NodePattern.N.withHeadRelation("obj|expl:pv");
        private static final NodePattern iObjNmod = NodePattern.N.withHead("iobj|nmod", NodePattern.N.noDependents("obj"));
        @Nullable
        final String preposition;
        final Case caze;
        @Nullable
        final AnimacyStatus animacy;

        private NominalArgument(String presentable, @Nullable String preposition, Case caze, @Nullable AnimacyStatus animacy) {
            super(presentable, NodePattern.N.withHeadRelation(preposition == null ? "i?obj|nmod|expl:pv" : "obl|nmod").andOr(NodePattern.N.pos(".*" + caze.name() + ".*"), NodePattern.N.withDependent("flat", Case.misparsedFlatHead.pos(".*" + caze.name() + ".*")), caze.name().equals("AKK") ? NodePattern.custom(n -> n.headRelation().equals("obj")) : NodePattern.not(NodePattern.N)).and(node -> animacy == AnimacyStatus.NOT_STATED || animacy == AnimacyStatus.ANIMATE && SemanticRules.animate.matches((Node)node) || animacy == AnimacyStatus.INANIMATE && SemanticRules.inanimate.matches((Node)node)).and(node -> !caze.name().equals("AKK") || oblExplPv.matches((Node)node) || iObjNmod.matches((Node)node)).and(node -> {
                Node prep = GermanTreePatterns.findPreposition(node);
                if (preposition == null) {
                    return prep == null;
                }
                return prep != null && GermanValences.normalizePreposition(prep).equals(preposition);
            }));
            this.preposition = preposition;
            this.caze = caze;
            this.animacy = animacy;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            NominalArgument argument = (NominalArgument)o;
            return Objects.equals(this.preposition, argument.preposition) && this.caze == argument.caze;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + Objects.hash(new Object[]{this.preposition, this.caze});
        }

        @Override
        public boolean isObligatory() {
            return this.preposition != null;
        }
    }

    static enum AnimacyStatus {
        ANIMATE,
        INANIMATE,
        NOT_STATED;

    }
}

