/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Deformably register two images using the demons algorithm.


This class was contributed by Corinne Mattmann, ETH Zurich,
Switzerland. based on a variation of the DemonsRegistrationFilter . The basic modification is to use equation (5) from Thirion's paper
along with the modification for avoiding large deformations when
gradients have small values.

SymmetricForcesDemonsRegistrationFilter implements the demons deformable algorithm that register two images
by computing the deformation field which will map a moving image onto
a fixed image.

A deformation field is represented as a image whose pixel type is some
vector type with at least N elements, where N is the dimension of the
fixed image. The vector type must support element access via operator
[]. It is assumed that the vector elements behave like floating point
scalars.

This class is templated over the fixed image type, moving image type
and the deformation field type.

The input fixed and moving images are set via methods SetFixedImage
and SetMovingImage respectively. An initial deformation field maybe
set via SetInitialDisplacementField or SetInput. If no initial field
is set, a zero field is used as the initial condition.

The algorithm has one parameters: the number of iteration to be
performed.

The output deformation field can be obtained via methods GetOutput or
GetDisplacementField.

This class make use of the finite difference solver hierarchy. Update
for each iteration is computed in DemonsRegistrationFunction .


WARNING:
This filter assumes that the fixed image type, moving image type and
deformation field type all have the same number of dimensions.

See:
 SymmetricForcesDemonsRegistrationFunction

 DemonsRegistrationFilter

 DemonsRegistrationFunction

 itk::SymmetricForcesDemonsRegistrationFilter for the Doxygen on the original ITK class.


C++ includes: sitkSymmetricForcesDemonsRegistrationFilter.h
*/
public class SymmetricForcesDemonsRegistrationFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SymmetricForcesDemonsRegistrationFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SymmetricForcesDemonsRegistrationFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SymmetricForcesDemonsRegistrationFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SymmetricForcesDemonsRegistrationFilter::~SymmetricForcesDemonsRegistrationFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SymmetricForcesDemonsRegistrationFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SymmetricForcesDemonsRegistrationFilter::SymmetricForcesDemonsRegistrationFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SymmetricForcesDemonsRegistrationFilter() {
    this(SimpleITKJNI.new_SymmetricForcesDemonsRegistrationFilter(), true);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(VectorDouble StandardDeviations) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(StandardDeviations), StandardDeviations);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetStandardDeviations(std::vector&lt; double &gt; StandardDeviations)

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  void setStandardDeviations(double value) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::SymmetricForcesDemonsRegistrationFilter::GetStandardDeviations() const

Set/Get the Gaussian smoothing standard deviations for the
displacement field. The values are set with respect to pixel
coordinates.

*/
public  VectorDouble getStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::SymmetricForcesDemonsRegistrationFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::SymmetricForcesDemonsRegistrationFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetSmoothDisplacementField(bool SmoothDisplacementField)

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  void setSmoothDisplacementField(boolean SmoothDisplacementField) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setSmoothDisplacementField(swigCPtr, this, SmoothDisplacementField);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOn()

Set the value of SmoothDisplacementField to true or false
respectfully.

*/
public  void smoothDisplacementFieldOn() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_smoothDisplacementFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SmoothDisplacementFieldOff()
*/
public  void smoothDisplacementFieldOff() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_smoothDisplacementFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::SymmetricForcesDemonsRegistrationFilter::GetSmoothDisplacementField() const

Set/Get whether the displacement field is smoothed (regularized).
Smoothing the displacement yields a solution elastic in nature. If
SmoothDisplacementField is on, then the displacement field is smoothed
with a Gaussian whose standard deviations are specified with SetStandardDeviations()

*/
public  boolean getSmoothDisplacementField() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getSmoothDisplacementField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetSmoothUpdateField(bool SmoothUpdateField)

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  void setSmoothUpdateField(boolean SmoothUpdateField) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setSmoothUpdateField(swigCPtr, this, SmoothUpdateField);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOn()

Set the value of SmoothUpdateField to true or false respectfully.

*/
public  void smoothUpdateFieldOn() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_smoothUpdateFieldOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SmoothUpdateFieldOff()
*/
public  void smoothUpdateFieldOff() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_smoothUpdateFieldOff(swigCPtr, this);
  }

  /**
bool itk::simple::SymmetricForcesDemonsRegistrationFilter::GetSmoothUpdateField() const

Set/Get whether the update field is smoothed (regularized). Smoothing
the update field yields a solution viscous in nature. If
SmoothUpdateField is on, then the update field is smoothed with a
Gaussian whose standard deviations are specified with SetUpdateFieldStandardDeviations()

*/
public  boolean getSmoothUpdateField() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getSmoothUpdateField(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(VectorDouble UpdateFieldStandardDeviations) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(UpdateFieldStandardDeviations), UpdateFieldStandardDeviations);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetUpdateFieldStandardDeviations(std::vector&lt; double &gt; UpdateFieldStandardDeviations)

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  void setUpdateFieldStandardDeviations(double value) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setUpdateFieldStandardDeviations__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::SymmetricForcesDemonsRegistrationFilter::GetUpdateFieldStandardDeviations() const

Set the Gaussian smoothing standard deviations for the update field.
The values are set with respect to pixel coordinates.

*/
public  VectorDouble getUpdateFieldStandardDeviations() {
    return new VectorDouble(SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getUpdateFieldStandardDeviations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set/Get the desired limits of the Gaussian kernel width.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::SymmetricForcesDemonsRegistrationFilter::GetMaximumKernelWidth() const

Set/Get the desired limits of the Gaussian kernel width.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetMaximumError(double MaximumError)

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::SymmetricForcesDemonsRegistrationFilter::GetMaximumError() const

Set/Get the desired maximum error of the Guassian kernel approximate.

*/
public  double getMaximumError() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getMaximumError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetIntensityDifferenceThreshold(double IntensityDifferenceThreshold)

Set/Get the threshold below which the absolute difference of intensity
yields a match. When the intensities match between a moving and fixed
image pixel, the update vector (for that iteration) will be the zero
vector. Default is 0.001.

*/
public  void setIntensityDifferenceThreshold(double IntensityDifferenceThreshold) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setIntensityDifferenceThreshold(swigCPtr, this, IntensityDifferenceThreshold);
  }

  /**
double itk::simple::SymmetricForcesDemonsRegistrationFilter::GetIntensityDifferenceThreshold() const
*/
public  double getIntensityDifferenceThreshold() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getIntensityDifferenceThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::SetUseImageSpacing(bool UseImageSpacing)
*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SymmetricForcesDemonsRegistrationFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::SymmetricForcesDemonsRegistrationFilter::GetUseImageSpacing() const
*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
uint32_t itk::simple::SymmetricForcesDemonsRegistrationFilter::GetElapsedIterations() const

Number of iterations run.


This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::SymmetricForcesDemonsRegistrationFilter::GetRMSChange() const

Set/Get the root mean squared change of the previous iteration. May
not be used by all solvers.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getRMSChange(swigCPtr, this);
  }

  /**
double itk::simple::SymmetricForcesDemonsRegistrationFilter::GetMetric() const

Get the metric value. The metric value is the mean square difference
in intensity between the fixed image and transforming moving image
computed over the overlapping region between the two images. This
value is calculated for the current iteration

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getMetric() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getMetric(swigCPtr, this);
  }

  /**
void itk::simple::SymmetricForcesDemonsRegistrationFilter::StopRegistration()

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  void stopRegistration() {
    SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_stopRegistration(swigCPtr, this);
  }

  /**
std::string itk::simple::SymmetricForcesDemonsRegistrationFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SymmetricForcesDemonsRegistrationFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SymmetricForcesDemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage, Image initialDisplacementField) {
    return new Image(SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage, Image.getCPtr(initialDisplacementField), initialDisplacementField), true);
  }

  /**
Image itk::simple::SymmetricForcesDemonsRegistrationFilter::Execute(const Image &amp;fixedImage, const Image &amp;movingImage, const
Image &amp;initialDisplacementField)

Execute the filter on the input image

*/
public  Image execute(Image fixedImage, Image movingImage) {
    return new Image(SimpleITKJNI.SymmetricForcesDemonsRegistrationFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(fixedImage), fixedImage, Image.getCPtr(movingImage), movingImage), true);
  }

}
