/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;

public class FFTPadImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected FFTPadImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.FFTPadImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(FFTPadImageFilter fFTPadImageFilter) {
        return fFTPadImageFilter == null ? 0L : fFTPadImageFilter.swigCPtr;
    }

    protected static long swigRelease(FFTPadImageFilter fFTPadImageFilter) {
        long l = 0L;
        if (fFTPadImageFilter != null) {
            if (!fFTPadImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = fFTPadImageFilter.swigCPtr;
            fFTPadImageFilter.swigCMemOwn = false;
            fFTPadImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_FFTPadImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public FFTPadImageFilter() {
        this(SimpleITKJNI.new_FFTPadImageFilter(), true);
    }

    public void setBoundaryCondition(BoundaryConditionType boundaryConditionType) {
        SimpleITKJNI.FFTPadImageFilter_setBoundaryCondition(this.swigCPtr, this, boundaryConditionType.swigValue());
    }

    public BoundaryConditionType getBoundaryCondition() {
        return BoundaryConditionType.swigToEnum(SimpleITKJNI.FFTPadImageFilter_getBoundaryCondition(this.swigCPtr, this));
    }

    public void setSizeGreatestPrimeFactor(int n) {
        SimpleITKJNI.FFTPadImageFilter_setSizeGreatestPrimeFactor(this.swigCPtr, this, n);
    }

    public int getSizeGreatestPrimeFactor() {
        return SimpleITKJNI.FFTPadImageFilter_getSizeGreatestPrimeFactor(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.FFTPadImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.FFTPadImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.FFTPadImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }

    public static int defaultSizeGreatestPrimeFactor() {
        return SimpleITKJNI.FFTPadImageFilter_defaultSizeGreatestPrimeFactor();
    }

    public static final class BoundaryConditionType {
        public static final BoundaryConditionType ZERO_PAD = new BoundaryConditionType("ZERO_PAD");
        public static final BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
        public static final BoundaryConditionType PERIODIC_PAD = new BoundaryConditionType("PERIODIC_PAD");
        private static BoundaryConditionType[] swigValues = new BoundaryConditionType[]{ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static BoundaryConditionType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && BoundaryConditionType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (BoundaryConditionType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(BoundaryConditionType.class) + " with value " + n);
        }

        private BoundaryConditionType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private BoundaryConditionType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private BoundaryConditionType(String string, BoundaryConditionType boundaryConditionType) {
            this.swigName = string;
            this.swigValue = boundaryConditionType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

