
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The canSetParameter method checks if setting a parameter to a specific value is supported.
 *  
 *  The parameter element-content-whitespace is turned on by default. Set this parameter to false will
 *  discard all Text nodes that contain whitespaces in element content, as described in [element content whitespace].
 *  Check to see if this feature can be set to false by invoking canSetParameter method.  Verify that the text node
 *  still exist after invoking canSetParameter.
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#DOMConfiguration</a>
*/
public final class domconfigurationcansetparameter06 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public domconfigurationcansetparameter06(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      DOMConfiguration domConfig;
      NodeList itemList;
      Element elementStrong;
      Text textNode;
      boolean canSet;
      boolean hasWhitespace;
      doc = (Document) load("hc_staff", false);
      domConfig = doc.getDomConfig();
      canSet = domConfig.canSetParameter("element-content-whitespace", Boolean.TRUE);
      assertTrue("domconfigurationcansetparameter06_1", canSet);
      itemList = doc.getElementsByTagNameNS("*", "strong");
      elementStrong = (Element) itemList.item(0);
      textNode = (Text) elementStrong.getFirstChild();
      textNode.setTextContent("                                                ");
      hasWhitespace = textNode.isElementContentWhitespace();
      assertTrue("domconfigurationsetparameter06_2", hasWhitespace);
      doc.normalizeDocument();
      itemList = doc.getElementsByTagNameNS("*", "strong");
      elementStrong = (Element) itemList.item(0);
      textNode = (Text) elementStrong.getFirstChild();
      hasWhitespace = textNode.isElementContentWhitespace();
      assertTrue("domconfigurationsetparameter06_3", hasWhitespace);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/domconfigurationcansetparameter06";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(domconfigurationcansetparameter06.class, args);
   }
}

