/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IComponentInheritedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.PropertyModel;

public class CompoundPropertyModel<T>
extends ChainingModel<T>
implements IComponentInheritedModel<T> {
    private static final long serialVersionUID = 1L;

    public CompoundPropertyModel(IModel<T> model) {
        super(model);
    }

    public CompoundPropertyModel(T object) {
        super(object);
    }

    protected String propertyExpression(Component component) {
        return component.getId();
    }

    @Override
    public <C> IWrapModel<C> wrapOnInheritance(Component component) {
        return new AttachedCompoundPropertyModel(component);
    }

    public <S> IModel<S> bind(String property) {
        return new PropertyModel(this, property);
    }

    public static <Z> CompoundPropertyModel<Z> of(IModel<Z> model) {
        return new CompoundPropertyModel<IModel<Z>>(model);
    }

    public static <Z extends Serializable> CompoundPropertyModel<Z> of(Z object) {
        return new CompoundPropertyModel<Z>(object);
    }

    private class AttachedCompoundPropertyModel<C>
    extends AbstractPropertyModel<C>
    implements IWrapModel<C> {
        private static final long serialVersionUID = 1L;
        private final Component owner;

        AttachedCompoundPropertyModel(Component owner) {
            super(CompoundPropertyModel.this);
            this.owner = owner;
        }

        @Override
        protected String propertyExpression() {
            return CompoundPropertyModel.this.propertyExpression(this.owner);
        }

        @Override
        public IModel<T> getWrappedModel() {
            return CompoundPropertyModel.this;
        }

        @Override
        public void detach() {
            super.detach();
            CompoundPropertyModel.this.detach();
        }
    }
}

