/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ProxyFactory;

public class BatchProxyInvocationHandler
implements InvocationHandler {
    private final InjectionReferences injectionRefs;
    private final Object delegate;
    private final String[] nonExceptionHandlingMethods;

    public BatchProxyInvocationHandler(Object delegate, InjectionReferences injectionRefs, String ... nonExceptionHandlingMethods) {
        this.delegate = delegate;
        this.injectionRefs = injectionRefs;
        this.nonExceptionHandlingMethods = nonExceptionHandlingMethods;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InjectionReferences oldInjectionRefs = ProxyFactory.setInjectionReferences(this.injectionRefs);
        try {
            Object object = method.invoke(this.delegate, args);
            return object;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = e.getCause();
            }
            if ((this.nonExceptionHandlingMethods == null || Arrays.binarySearch(this.nonExceptionHandlingMethods, method.getName()) < 0) && e instanceof Exception) {
                if (this.injectionRefs.getStepContext() != null) {
                    this.injectionRefs.getStepContext().setException((Exception)e);
                }
                throw new BatchContainerRuntimeException(e);
            }
            throw e;
        }
        finally {
            ProxyFactory.setInjectionReferences(oldInjectionRefs);
        }
    }
}

