/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.SemanticAttributes;
import javax.annotation.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final ServerAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final PeerServiceResolver peerServiceResolver;

    PeerServiceAttributesExtractor(ServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        this.attributesGetter = attributesGetter;
        this.peerServiceResolver = peerServiceResolver;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(ServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, peerServiceResolver);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer serverPort;
        if (this.peerServiceResolver.isEmpty()) {
            return;
        }
        String serverAddress = this.attributesGetter.getServerAddress(request);
        String peerService = this.mapToPeerService(serverAddress, serverPort = this.attributesGetter.getServerPort(request));
        if (peerService == null && SemconvStability.emitOldHttpSemconv()) {
            String serverSocketDomain = this.attributesGetter.getServerSocketDomain(request, response);
            Integer serverSocketPort = this.attributesGetter.getServerSocketPort(request, response);
            peerService = this.mapToPeerService(serverSocketDomain, serverSocketPort);
        }
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, (Object)peerService);
        }
    }

    @Nullable
    private String mapToPeerService(@Nullable String host, @Nullable Integer port) {
        if (host == null) {
            return null;
        }
        return this.peerServiceResolver.resolveService(host, port, null);
    }
}

