/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryIo;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryMapper;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.Marker;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseStatus;
import org.apache.tinkerpop.gremlin.util.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.NettyBufferFactory;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.gremlin.util.ser.binary.RequestMessageSerializer;
import org.javatuples.Pair;
import org.javatuples.Triplet;

public class GraphBinaryMessageSerializerV4
extends AbstractMessageSerializer<GraphBinaryMapper> {
    public static final String TOKEN_CUSTOM = "custom";
    public static final String TOKEN_BUILDER = "builder";
    private GraphBinaryReader reader;
    private GraphBinaryWriter writer;
    private RequestMessageSerializer requestSerializer;
    private final GraphBinaryMapper mapper;
    private static final NettyBufferFactory bufferFactory = new NettyBufferFactory();
    private static final String MIME_TYPE = "application/vnd.graphbinary-v4.0";

    public GraphBinaryMessageSerializerV4() {
        this(TypeSerializerRegistry.INSTANCE);
    }

    public GraphBinaryMessageSerializerV4(TypeSerializerRegistry registry) {
        this.reader = new GraphBinaryReader(registry);
        this.writer = new GraphBinaryWriter(registry);
        this.mapper = new GraphBinaryMapper(this.writer, this.reader);
        this.requestSerializer = new RequestMessageSerializer();
    }

    public GraphBinaryMessageSerializerV4(TypeSerializerRegistry.Builder builder) {
        this(builder.create());
    }

    @Override
    public GraphBinaryMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        TypeSerializerRegistry.Builder builder;
        String builderClassName = (String)config.get(TOKEN_BUILDER);
        if (builderClassName != null) {
            try {
                Class<?> clazz = Class.forName(builderClassName);
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                builder = (TypeSerializerRegistry.Builder)ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            builder = TypeSerializerRegistry.build();
        }
        List<String> classNameList = this.getListStringFromConfig("ioRegistries", config);
        classNameList.forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    Method instanceMethod = this.tryInstanceMethod(clazz);
                    IoRegistry ioreg = (IoRegistry)instanceMethod.invoke(null, new Object[0]);
                    List classSerializers = ioreg.find(GraphBinaryIo.class, CustomTypeSerializer.class);
                    for (Pair cs : classSerializers) {
                        builder.addCustomType((Class)cs.getValue0(), (CustomTypeSerializer)cs.getValue1());
                    }
                }
                catch (Exception methodex) {
                    throw new IllegalStateException(String.format("Could not instantiate IoRegistry from an instance() method on %s", className), methodex);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        });
        this.addCustomClasses(config, builder);
        TypeSerializerRegistry registry = builder.create();
        this.reader = new GraphBinaryReader(registry);
        this.writer = new GraphBinaryWriter(registry);
        this.requestSerializer = new RequestMessageSerializer();
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{MIME_TYPE};
    }

    private void addCustomClasses(Map<String, Object> config, TypeSerializerRegistry.Builder builder) {
        List<String> classNameList = this.getListStringFromConfig(TOKEN_CUSTOM, config);
        classNameList.forEach(serializerDefinition -> {
            String[] split;
            if (serializerDefinition.contains(";")) {
                split = serializerDefinition.split(";");
                if (split.length != 2) {
                    throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
                }
            } else {
                throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
            }
            String className = split[0];
            String serializerName = split[1];
            try {
                Class<?> clazz = Class.forName(className);
                Class<?> serializerClazz = Class.forName(serializerName);
                CustomTypeSerializer serializer = (CustomTypeSerializer)serializerClazz.newInstance();
                builder.addCustomType(clazz, serializer);
            }
            catch (Exception ex) {
                throw new IllegalStateException("CustomTypeSerializer could not be instantiated", ex);
            }
        });
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf buffer = allocator.buffer();
        try {
            this.requestSerializer.writeValue(requestMessage, buffer, this.writer);
        }
        catch (Exception ex) {
            buffer.release();
            throw ex;
        }
        return buffer;
    }

    @Override
    public RequestMessage deserializeBinaryRequest(ByteBuf msg) throws SerializationException {
        return this.requestSerializer.readValue(msg, this.reader);
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        if (null == responseMessage.getStatus()) {
            throw new SerializationException("ResponseStatus can't be null when serializing a full ResponseMessage.");
        }
        return this.writeHeader(responseMessage, allocator);
    }

    @Override
    public ByteBuf writeHeader(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        EnumSet<MessageSerializer.MessageParts> parts = responseMessage.getStatus() != null ? MessageSerializer.MessageParts.ALL : MessageSerializer.MessageParts.START;
        return this.write(responseMessage, null, allocator, parts);
    }

    @Override
    public ByteBuf writeChunk(Object aggregate, ByteBufAllocator allocator) throws SerializationException {
        return this.write(null, aggregate, allocator, MessageSerializer.MessageParts.CHUNK);
    }

    @Override
    public ByteBuf writeFooter(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        return this.write(responseMessage, null, allocator, MessageSerializer.MessageParts.END);
    }

    @Override
    public ByteBuf writeErrorFooter(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        return this.write(responseMessage, null, allocator, MessageSerializer.MessageParts.ERROR);
    }

    private ByteBuf write(ResponseMessage responseMessage, Object aggregate, ByteBufAllocator allocator, EnumSet<MessageSerializer.MessageParts> parts) throws SerializationException {
        ByteBuf byteBuf = allocator.buffer();
        Buffer buffer = bufferFactory.create(byteBuf);
        try {
            if (parts.contains((Object)MessageSerializer.MessageParts.HEADER)) {
                buffer.writeByte(-127);
                if (responseMessage.getResult().isBulked()) {
                    buffer.writeByte(1);
                } else {
                    buffer.writeByte(0);
                }
            }
            if (parts.contains((Object)MessageSerializer.MessageParts.DATA)) {
                List<Object> data;
                List<Object> list = data = aggregate == null && responseMessage.getResult() != null ? responseMessage.getResult().getData() : aggregate;
                if (data != null) {
                    for (Object item : data) {
                        this.writer.write(item, buffer);
                    }
                }
            }
            if (parts.contains((Object)MessageSerializer.MessageParts.FOOTER)) {
                ResponseStatus status = responseMessage.getStatus();
                this.writer.write((Object)Marker.END_OF_STREAM, buffer);
                this.writer.writeValue((Object)status.getCode().code(), buffer, false);
                this.writer.writeValue((Object)status.getMessage(), buffer, true);
                this.writer.writeValue((Object)status.getException(), buffer, true);
            }
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return byteBuf;
    }

    @Override
    public ResponseMessage deserializeBinaryResponse(ByteBuf msg) throws SerializationException {
        return this.readChunk(msg, true);
    }

    private List<Object> readPayload(Buffer buffer) throws IOException {
        Object obj;
        ArrayList<Object> result = new ArrayList<Object>();
        while (buffer.readableBytes() != 0 && !Marker.END_OF_STREAM.equals(obj = this.reader.read(buffer))) {
            result.add(obj);
        }
        return result;
    }

    private Triplet<HttpResponseStatus, String, String> readFooter(Buffer buffer) throws IOException {
        HttpResponseStatus statusCode = HttpResponseStatus.valueOf((int)((Integer)this.reader.readValue(buffer, Integer.class, false)));
        String message = (String)this.reader.readValue(buffer, String.class, true);
        String exception = (String)this.reader.readValue(buffer, String.class, true);
        return Triplet.with((Object)statusCode, (Object)message, (Object)exception);
    }

    @Override
    public ResponseMessage readChunk(ByteBuf byteBuf, boolean isFirstChunk) throws SerializationException {
        Buffer buffer = bufferFactory.create(byteBuf);
        boolean bulking = false;
        try {
            if (buffer.readableBytes() == 0) {
                return ResponseMessage.build().result(Collections.emptyList()).create();
            }
            if (isFirstChunk) {
                int version = buffer.readByte() & 0xFF;
                if (version >>> 7 != 1) {
                    throw new SerializationException("The most significant bit should be set according to the format");
                }
                bulking = (buffer.readByte() & 1) == 1;
            }
            List<Object> result = this.readPayload(buffer);
            if (buffer.readableBytes() == 0) {
                return ResponseMessage.build().result(result).bulked(bulking).create();
            }
            Triplet<HttpResponseStatus, String, String> footer = this.readFooter(buffer);
            return ResponseMessage.build().result(result).bulked(bulking).code((HttpResponseStatus)footer.getValue0()).statusMessage((String)footer.getValue1()).exception((String)footer.getValue2()).create();
        }
        catch (IOException | IndexOutOfBoundsException ex) {
            throw new SerializationException(ex);
        }
    }
}

