/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import org.apache.tinkerpop.gremlin.server.handler.HttpHandlerUtil;

@ChannelHandler.Sharable
public class HttpRequestCheckingHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public HttpRequestCheckingHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        if (msg.protocolVersion() != HttpVersion.HTTP_1_1) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED, "Only HTTP/1.1 is supported.");
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        if ("/favicon.ico".equals(msg.uri())) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.NOT_FOUND, "Gremlin Server doesn't have a favicon.ico");
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        ctx.fireChannelRead((Object)msg);
    }
}

