/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.handler.HttpGremlinEndpointHandler;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.util.GremlinError;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.node.ObjectNode;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandlerUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpHandlerUtil.class);
    static final Meter errorMeter = MetricManager.INSTANCE.getMeter(MetricRegistry.name(GremlinServer.class, (String[])new String[]{"errors"}));
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
        logger.warn(String.format("Invalid request - responding with %s and %s", status, message));
        errorMeter.mark();
        ObjectNode node = mapper.createObjectNode();
        node.put("message", message);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)node.toString(), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        ctx.writeAndFlush((Object)response);
    }

    static void writeError(Context context, ResponseMessage responseMessage, MessageSerializer<?> serializer) {
        try {
            ChannelHandlerContext ctx = context.getChannelHandlerContext();
            ByteBuf ByteBuf2 = context.getRequestState() == HttpGremlinEndpointHandler.RequestState.STREAMING ? serializer.writeErrorFooter(responseMessage, ctx.alloc()) : serializer.serializeResponseAsBinary(responseMessage, ctx.alloc());
            context.setRequestState(HttpGremlinEndpointHandler.RequestState.ERROR);
            if (!((Boolean)ctx.channel().attr(StateKey.HTTP_RESPONSE_SENT).get()).booleanValue()) {
                DefaultHttpResponse responseHeader = new DefaultHttpResponse(HttpVersion.HTTP_1_1, responseMessage.getStatus().getCode());
                responseHeader.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                responseHeader.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, ((Pair)ctx.channel().attr(StateKey.SERIALIZER).get()).getValue0());
                ctx.writeAndFlush((Object)responseHeader);
                ctx.channel().attr(StateKey.HTTP_RESPONSE_SENT).set((Object)true);
            }
            ctx.writeAndFlush((Object)new DefaultHttpContent(ByteBuf2));
            HttpHandlerUtil.sendTrailingHeaders(ctx, responseMessage.getStatus().getCode(), responseMessage.getStatus().getException());
        }
        catch (SerializationException se) {
            logger.warn("Unable to serialize ResponseMessage: {} ", (Object)responseMessage);
        }
    }

    static void writeError(Context context, GremlinError error, MessageSerializer<?> serializer) {
        ResponseMessage responseMessage = ResponseMessage.build().code(error.getCode()).statusMessage(error.getMessage()).exception(error.getException()).create();
        HttpHandlerUtil.writeError(context, responseMessage, serializer);
    }

    static void sendTrailingHeaders(ChannelHandlerContext ctx, HttpResponseStatus statusCode, String exceptionType) {
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent();
        defaultLastHttpContent.trailingHeaders().add("code", (Object)statusCode.code());
        if (exceptionType != null && !exceptionType.isEmpty()) {
            defaultLastHttpContent.trailingHeaders().add("exception", (Object)exceptionType);
        }
        ctx.writeAndFlush((Object)defaultLastHttpContent);
    }
}

