/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import groovy.transform.TimedInterrupt;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyCustomizer;
import org.apache.tinkerpop.gremlin.groovy.jsr223.TimedInterruptTimeoutException;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;

class TimedInterruptGroovyCustomizer
implements GroovyCustomizer {
    private static final long DEFAULT_INTERRUPTION_TIMEOUT = 60000L;
    private final long interruptionTimeout;

    TimedInterruptGroovyCustomizer() {
        this(60000L);
    }

    TimedInterruptGroovyCustomizer(Long interruptionTimeout) {
        this.interruptionTimeout = interruptionTimeout;
    }

    TimedInterruptGroovyCustomizer(Integer interruptionTimeout) {
        this.interruptionTimeout = interruptionTimeout.longValue();
    }

    @Override
    public CompilationCustomizer create() {
        HashMap<String, Constable> timedInterruptAnnotationParams = new HashMap<String, Constable>();
        timedInterruptAnnotationParams.put("value", Long.valueOf(this.interruptionTimeout));
        timedInterruptAnnotationParams.put("unit", (Constable)GeneralUtils.propX((Expression)GeneralUtils.classX(TimeUnit.class), (String)TimeUnit.MILLISECONDS.toString()));
        timedInterruptAnnotationParams.put("checkOnMethodStart", Boolean.valueOf(false));
        timedInterruptAnnotationParams.put("thrown", (Constable)GeneralUtils.classX(TimedInterruptTimeoutException.class));
        return new ASTTransformationCustomizer(timedInterruptAnnotationParams, TimedInterrupt.class);
    }
}

