/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;

public class TraversalEnumParser {
    public static <E extends Enum<E>, C extends ParseTree> E parseTraversalEnumFromContext(Class<E> enumType, C context) {
        String className;
        String text = context.getText();
        if (text.startsWith(className = enumType.getSimpleName())) {
            String strippedText = text.substring(className.length() + 1);
            return Enum.valueOf(enumType, strippedText);
        }
        return Enum.valueOf(enumType, text);
    }

    public static Direction parseTraversalDirectionFromContext(GremlinParser.TraversalDirectionContext context) {
        String text = context.getText();
        if (text.startsWith(Direction.class.getSimpleName())) {
            text = text.substring(Direction.class.getSimpleName().length() + 1);
        }
        return Direction.directionValueOf(text);
    }

    public static Function parseTraversalFunctionFromContext(GremlinParser.TraversalFunctionContext context) {
        if (context.traversalToken() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(T.class, context.traversalToken());
        }
        if (context.traversalColumn() != null) {
            return TraversalEnumParser.parseTraversalEnumFromContext(Column.class, context.traversalColumn());
        }
        throw new GremlinParserException("Unrecognized enum for traversal function");
    }
}

