/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.DimensionalityReduction;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.internal.RangeArgument;
import org.apache.sis.referencing.util.DirectPositionView;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.CoverageQuery;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.NoSuchDataException;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class CoverageSubset
extends AbstractGridCoverageResource {
    private final GenericName name;
    private final GridCoverageResource source;
    private GridGeometry gridGeometry;
    private final GridGeometry areaOfInterest;
    private final DimensionalityReduction reduction;
    private final int sourceDomainExpansion;
    private final int[] selectedRange;

    CoverageSubset(GenericName name, GridCoverageResource source, CoverageQuery query) throws DataStoreException {
        super(source);
        this.name = name;
        this.source = source;
        this.reduction = query.getAxisSelection(source);
        GridGeometry selection = query.getSelection();
        if (selection != null && this.reduction != null && this.reduction.isReduced(selection)) {
            selection = this.reduction.reverse(selection);
        }
        this.areaOfInterest = selection;
        this.selectedRange = query.getProjection(source);
        this.sourceDomainExpansion = query.getSourceDomainExpansion();
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.ofNullable(this.name);
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        builder.addLineage(Resources.formatInternational((short)76));
        builder.addProcessDescription(Resources.formatInternational((short)77, StoreUtilities.getLabel(this.source)));
        builder.addSource(this.source.getMetadata());
        return builder.build();
    }

    @Override
    public List<double[]> getResolutions() throws DataStoreException {
        List<double[]> resolutions = this.source.getResolutions();
        if (this.reduction != null) {
            resolutions.stream().map(resolution -> this.reduction.apply(new DirectPositionView.Double((double[])resolution)).getCoordinate()).collect(Collectors.toList());
        }
        return resolutions;
    }

    @Override
    public synchronized GridGeometry getGridGeometry() throws DataStoreException {
        GridGeometry domain = this.gridGeometry;
        if (domain == null) {
            domain = this.clip(this.source.getGridGeometry(), GridRoundingMode.NEAREST, GridClippingMode.STRICT);
            if (this.reduction != null) {
                domain = this.reduction.apply(domain);
            }
            this.gridGeometry = domain;
        }
        return domain;
    }

    private GridGeometry clip(GridGeometry domain, GridRoundingMode rounding, GridClippingMode clipping) throws DataStoreException {
        if (domain == null) {
            return this.areaOfInterest;
        }
        if (this.areaOfInterest == null) {
            return domain;
        }
        try {
            GridDerivation derivation = domain.derive().rounding(rounding).clipping(clipping);
            if (this.sourceDomainExpansion != 0) {
                int[] margins = new int[domain.getDimension()];
                Arrays.fill(margins, this.sourceDomainExpansion);
                derivation.margin(margins);
            }
            return derivation.subgrid(this.areaOfInterest).build();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            String msg = Resources.forLocale(this.listeners.getLocale()).getString((short)57, this.listeners.getSourceName());
            Throwable cause = e.getCause();
            if (cause instanceof FactoryException || cause instanceof TransformException) {
                throw new DataStoreReferencingException(msg, cause);
            }
            if (e instanceof DisjointExtentException) {
                throw new NoSuchDataException(msg, e);
            }
            throw new DataStoreException(msg, e);
        }
    }

    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        List<SampleDimension> dimensions = this.source.getSampleDimensions();
        if (this.selectedRange == null) {
            return dimensions;
        }
        SampleDimension[] subset = new SampleDimension[this.selectedRange.length];
        for (int i = 0; i < this.selectedRange.length; ++i) {
            int j = this.selectedRange[i];
            try {
                subset[i] = dimensions.get(j);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new DataStoreException(e);
            }
        }
        return UnmodifiableArrayList.wrap(subset);
    }

    @Override
    public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return this.source.getLoadingStrategy();
    }

    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy strategy) throws DataStoreException {
        return this.source.setLoadingStrategy(strategy);
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        if (this.reduction != null) {
            domain = this.reduction.reverse(domain);
        }
        if (domain == null) {
            domain = this.source.getGridGeometry();
        }
        domain = this.clip(domain, GridRoundingMode.ENCLOSING, GridClippingMode.BORDER_EXPANSION);
        if (this.selectedRange != null) {
            RangeArgument validation = RangeArgument.validate(this.selectedRange.length, ranges, this.listeners);
            ranges = new int[validation.getNumBands()];
            for (int i = 0; i < ranges.length; ++i) {
                ranges[validation.getTargetIndex((int)i)] = this.selectedRange[validation.getSourceIndex(i)];
            }
        }
        GridCoverage coverage = this.source.read(domain, ranges);
        if (this.reduction != null) {
            coverage = this.reduction.apply(coverage);
        }
        return coverage;
    }
}

