/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.lops.CentralMoment;
import org.apache.sysds.lops.CoVariance;
import org.apache.sysds.lops.FunctionCallCP;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.MMCJ;
import org.apache.sysds.lops.MMRJ;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.lops.MMZip;
import org.apache.sysds.lops.MapMult;
import org.apache.sysds.lops.MapMultChain;
import org.apache.sysds.lops.PickByCount;
import org.apache.sysds.lops.UnaryCP;
import org.apache.sysds.parser.StatementBlock;

public class OperatorOrderingUtils {
    public static ArrayList<Lop> getLopList(StatementBlock sb) {
        ArrayList<Lop> lops = null;
        if (sb.getLops() != null && !sb.getLops().isEmpty()) {
            lops = new ArrayList<Lop>();
            for (Lop root : sb.getLops()) {
                OperatorOrderingUtils.addToLopList(lops, root);
            }
        }
        return lops;
    }

    public static boolean isLopRoot(Lop lop) {
        if (lop.getOutputs().isEmpty()) {
            return true;
        }
        return lop instanceof FunctionCallCP && ((FunctionCallCP)lop).getFnamespace().equalsIgnoreCase("_internal");
    }

    public static int collectSparkRoots(Lop root, Map<Long, Integer> sparkOpCount, List<Lop> sparkRoots) {
        if (sparkOpCount.containsKey(root.getID())) {
            return sparkOpCount.get(root.getID());
        }
        int total = 0;
        for (Lop input : root.getInputs()) {
            total += OperatorOrderingUtils.collectSparkRoots(input, sparkOpCount, sparkRoots);
        }
        total = root.isExecSpark() ? total + 1 : total;
        sparkOpCount.put(root.getID(), total);
        if (OperatorOrderingUtils.isSparkTriggeringOp(root)) {
            sparkRoots.add(root);
            root.setAsynchronous(true);
        }
        return total;
    }

    public static boolean isPersistableSparkOp(Lop lop) {
        return lop.isExecSpark() && (lop instanceof MapMult || lop instanceof MMCJ || lop instanceof MMRJ || lop instanceof MMZip);
    }

    private static boolean isSparkTriggeringOp(Lop lop) {
        boolean rightSpLop = lop.isExecSpark() && (lop.getAggType() == AggBinaryOp.SparkAggType.SINGLE_BLOCK || lop.getDataType() == Types.DataType.SCALAR || lop instanceof MapMultChain || lop instanceof PickByCount || lop instanceof MMZip || lop instanceof CentralMoment || lop instanceof CoVariance || lop instanceof MMTSJ || lop.isAllOutputsCP());
        boolean isPrefetched = lop.getOutputs().size() == 1 && lop.getOutputs().get(0) instanceof UnaryCP && ((UnaryCP)lop.getOutputs().get(0)).getOpCode().equalsIgnoreCase("prefetch");
        boolean col2Bc = OperatorOrderingUtils.isCollectForBroadcast(lop);
        boolean prefetch = lop instanceof UnaryCP && ((UnaryCP)lop).getOpCode().equalsIgnoreCase("prefetch");
        return (rightSpLop || col2Bc || prefetch) && !isPrefetched;
    }

    public static boolean isCollectForBroadcast(Lop lop) {
        boolean isSparkOp = lop.isExecSpark();
        boolean isBc = lop.getOutputs().stream().allMatch(out -> out.getBroadcastInput() == lop);
        return isSparkOp && isBc && lop.getDataType() == Types.DataType.MATRIX;
    }

    private static boolean addNode(ArrayList<Lop> lops, Lop node) {
        if (lops.contains(node)) {
            return false;
        }
        lops.add(node);
        return true;
    }

    private static void addToLopList(ArrayList<Lop> lops, Lop lop) {
        if (OperatorOrderingUtils.addNode(lops, lop)) {
            for (Lop in : lop.getInputs()) {
                OperatorOrderingUtils.addToLopList(lops, in);
            }
        }
    }
}

