/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.u2f;

import com.yubico.u2f.U2F;
import com.yubico.u2f.data.DeviceRegistration;
import com.yubico.u2f.data.messages.SignRequestData;
import com.yubico.u2f.data.messages.SignResponse;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.u2f.U2FTokenCredential;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRegistration;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.ObjectProvider;

public class U2FAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler
implements MultifactorAuthenticationHandler {
    private final U2F u2f;
    private final U2FDeviceRepository u2FDeviceRepository;
    private final ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider;

    public U2FAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, U2FDeviceRepository u2FDeviceRepository, U2F u2f, Integer order, ObjectProvider<MultifactorAuthenticationProvider> multifactorAuthenticationProvider) {
        super(name, servicesManager, principalFactory, order);
        this.u2f = u2f;
        this.u2FDeviceRepository = u2FDeviceRepository;
        this.multifactorAuthenticationProvider = multifactorAuthenticationProvider;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws PreventedException {
        U2FTokenCredential tokenCredential = (U2FTokenCredential)credential;
        Authentication authentication = Objects.requireNonNull(WebUtils.getInProgressAuthentication(), "CAS has no reference to an authentication event to locate a principal");
        Principal principal = this.principalFactory.createPrincipal(authentication.getPrincipal().getId());
        try {
            SignResponse authenticateResponse = SignResponse.fromJson((String)tokenCredential.getToken());
            String requestId = authenticateResponse.getRequestId();
            String authJson = this.u2FDeviceRepository.getDeviceAuthenticationRequest(requestId, principal.getId());
            if (StringUtils.isBlank((CharSequence)authJson)) {
                throw new PreventedException("Could not get device authentication request from repository for request id " + requestId);
            }
            SignRequestData authenticateRequest = SignRequestData.fromJson((String)authJson);
            List registeredDevices = this.u2FDeviceRepository.getRegisteredDevices(principal.getId()).stream().map(this.u2FDeviceRepository::decode).map(Unchecked.function(r -> DeviceRegistration.fromJson((String)r.getRecord()))).filter(Objects::nonNull).collect(Collectors.toList());
            if (registeredDevices.isEmpty()) {
                throw new PreventedException("No registered devices could be found for " + principal.getId());
            }
            DeviceRegistration registration = this.u2f.finishSignature(authenticateRequest, authenticateResponse, registeredDevices);
            Object record = ((U2FDeviceRegistration.U2FDeviceRegistrationBuilder)((U2FDeviceRegistration.U2FDeviceRegistrationBuilder)U2FDeviceRegistration.builder().record((String)this.u2FDeviceRepository.getCipherExecutor().encode((Object)registration.toJsonWithAttestationCert()))).username(principal.getId())).build();
            this.u2FDeviceRepository.verifyRegisteredDevice((U2FDeviceRegistration)record);
            return this.createHandlerResult((Credential)tokenCredential, principal);
        }
        catch (Exception e) {
            throw new PreventedException((Throwable)e);
        }
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return U2FTokenCredential.class.isAssignableFrom(clazz);
    }

    public boolean supports(Credential credential) {
        return U2FTokenCredential.class.isAssignableFrom(credential.getClass());
    }

    @Generated
    public U2F getU2f() {
        return this.u2f;
    }

    @Generated
    public U2FDeviceRepository getU2FDeviceRepository() {
        return this.u2FDeviceRepository;
    }

    @Generated
    public ObjectProvider<MultifactorAuthenticationProvider> getMultifactorAuthenticationProvider() {
        return this.multifactorAuthenticationProvider;
    }
}

