/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.support;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.support.DefaultLdapAccountStateHandler;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.ldaptive.LdapAttribute;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalWarningLdapAccountStateHandler
extends DefaultLdapAccountStateHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionalWarningLdapAccountStateHandler.class);
    private String warnAttributeName;
    private String warningAttributeValue;
    private boolean displayWarningOnMatch;

    @Override
    protected void handleWarning(AccountState.Warning warning, AuthenticationResponse response, PasswordPolicyContext configuration, List<MessageDescriptor> messages) {
        if (StringUtils.isBlank((CharSequence)this.warnAttributeName)) {
            LOGGER.debug("No warning attribute name is defined");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.warningAttributeValue)) {
            LOGGER.debug("No warning attribute value to match is defined");
            return;
        }
        LdapAttribute attribute = response.getLdapEntry().getAttribute(this.warnAttributeName);
        boolean matches = false;
        if (attribute != null) {
            LOGGER.debug("Found warning attribute [{}] with value [{}]", (Object)attribute.getName(), (Object)attribute.getStringValue());
            matches = this.warningAttributeValue.equals(attribute.getStringValue());
        }
        LOGGER.debug("matches=[{}], displayWarningOnMatch=[{}]", (Object)matches, (Object)this.displayWarningOnMatch);
        if (this.displayWarningOnMatch == matches) {
            super.handleWarning(warning, response, configuration, messages);
        }
    }

    @Generated
    public String getWarnAttributeName() {
        return this.warnAttributeName;
    }

    @Generated
    public String getWarningAttributeValue() {
        return this.warningAttributeValue;
    }

    @Generated
    public boolean isDisplayWarningOnMatch() {
        return this.displayWarningOnMatch;
    }

    @Generated
    public void setWarnAttributeName(String warnAttributeName) {
        this.warnAttributeName = warnAttributeName;
    }

    @Generated
    public void setWarningAttributeValue(String warningAttributeValue) {
        this.warningAttributeValue = warningAttributeValue;
    }

    @Generated
    public void setDisplayWarningOnMatch(boolean displayWarningOnMatch) {
        this.displayWarningOnMatch = displayWarningOnMatch;
    }
}

