/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.dao.NoOpCasEventRepository;
import org.apereo.cas.support.events.listener.CasAuthenticationAuthenticationEventListener;
import org.apereo.cas.support.events.listener.CasAuthenticationEventListener;
import org.apereo.cas.support.events.web.CasEventsReportEndpoint;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.text.MessageSanitizer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Events)
@AutoConfiguration
public class CasCoreEventsConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.events.core.enabled").isTrue().evenIfMissing();

    @Configuration(value="CasCoreEventsRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreEventsRepositoryConfiguration {
        @ConditionalOnMissingBean(name={"casEventRepository"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasEventRepository casEventRepository(ConfigurableApplicationContext applicationContext) throws Exception {
            return (CasEventRepository)BeanSupplier.of(CasEventRepository.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> NoOpCasEventRepository.INSTANCE).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreEventsWebConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreEventsWebConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasEventsReportEndpoint casEventsReportEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new CasEventsReportEndpoint(casProperties, (ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="CasCoreEventsListenerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreEventsListenerConfiguration {
        @ConditionalOnMissingBean(name={"defaultCasEventListener"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasAuthenticationEventListener defaultCasEventListener(@Qualifier(value="messageSanitizer") MessageSanitizer messageSanitizer, ConfigurableApplicationContext applicationContext, @Qualifier(value="casEventRepository") CasEventRepository casEventRepository) throws Exception {
            return (CasAuthenticationEventListener)BeanSupplier.of(CasAuthenticationEventListener.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new CasAuthenticationAuthenticationEventListener(casEventRepository, messageSanitizer)).otherwiseProxy().get();
        }
    }
}

