/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.Provider;
import com.microsoft.alm.oauth2.useragent.Version;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class JavaFxProvider
extends Provider {
    private static final List<String> REQUIREMENTS = Collections.unmodifiableList(Arrays.asList("Oracle Java SE 7 update 6 or higher, Oracle Java SE 8, OR OpenJDK 8.", "JavaFX or OpenJFX runtime JAR.", "A desktop environment.", "Oracle Java SE 7 is not supported on Mac OS X 10.11 and greater.  Please upgrade to Java 8."));
    private final File[] potentialJavaFxJarLocations = new File[]{new File(JAVA_HOME, "lib/jfxrt.jar"), new File(JAVA_HOME, "lib/ext/jfxrt.jar")};

    protected JavaFxProvider() {
        super("JavaFx");
    }

    @Override
    public List<String> checkRequirements() {
        return JavaFxProvider.checkRequirements(JAVA_RUNTIME_VERSION, this.potentialJavaFxJarLocations, OS_NAME, OS_VERSION, ENV_DISPLAY);
    }

    /*
     * Enabled aggressive block sorting
     */
    static ArrayList<String> checkRequirements(String javaRuntimeVersionString, File[] potentialJavaFxJarLocations, String osName, String osVersionString, String displayVariable) {
        Version osVersion;
        ArrayList<String> requirements = new ArrayList<String>();
        Version javaVersion = Version.parseJavaRuntimeVersion(javaRuntimeVersionString);
        boolean hasSupportedJava = false;
        int javaMajorVersion = javaVersion.getMajor();
        int javaMinorVersion = javaVersion.getMinor();
        int javaUpdateVersion = javaVersion.getUpdate();
        switch (javaMajorVersion) {
            case 1: {
                switch (javaMinorVersion) {
                    case 8: {
                        hasSupportedJava = true;
                        break;
                    }
                    case 7: {
                        if (javaUpdateVersion < 6) break;
                        hasSupportedJava = true;
                    }
                }
                break;
            }
        }
        if (!hasSupportedJava) {
            requirements.add(REQUIREMENTS.get(0));
        } else if (JavaFxProvider.isMac(osName) && javaMajorVersion == 1 && javaMinorVersion == 7 && (osVersion = Version.parseVersion(osVersionString)).getMajor() == 10 && osVersion.getMinor() >= 11) {
            requirements.add(REQUIREMENTS.get(3));
        }
        boolean hasJavaFx = false;
        for (File potentialJavaFxJar : potentialJavaFxJarLocations) {
            if (!potentialJavaFxJar.isFile()) continue;
            hasJavaFx = true;
            break;
        }
        if (!hasJavaFx) {
            requirements.add(REQUIREMENTS.get(1));
        }
        if (!JavaFxProvider.hasDesktop(osName, displayVariable)) {
            requirements.add(REQUIREMENTS.get(2));
        }
        return requirements;
    }

    @Override
    public void augmentProcessParameters(List<String> command, List<String> classPath) {
        File javaFxJar = null;
        for (File potentialJavaFxJar : this.potentialJavaFxJarLocations) {
            if (!potentialJavaFxJar.isFile()) continue;
            javaFxJar = potentialJavaFxJar;
            break;
        }
        if (javaFxJar != null) {
            classPath.add(javaFxJar.getAbsolutePath());
        }
    }
}

