/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizer;
import org.pac4j.core.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedAuthenticationServiceTicketValidationAuthorizer
implements ServiceTicketValidationAuthorizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedAuthenticationServiceTicketValidationAuthorizer.class);
    private final ServicesManager servicesManager;
    private final AuditableExecution delegatedAuthenticationPolicyEnforcer;

    public void authorize(HttpServletRequest request, Service service, Assertion assertion) {
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
        LOGGER.debug("Evaluating service [{}] for delegated authentication policy", (Object)service);
        Optional.ofNullable(registeredService.getAccessStrategy().getDelegatedAuthenticationPolicy()).ifPresent(policy -> {
            List clientNameAttr;
            Optional value;
            Map attributes = assertion.getPrimaryAuthentication().getAttributes();
            if (attributes.containsKey("clientName") && (value = CollectionUtils.firstElement((Object)(clientNameAttr = (List)attributes.get("clientName")))).isPresent()) {
                String client = value.get().toString();
                LOGGER.debug("Evaluating delegated authentication policy [{}] for client [{}] and service [{}]", new Object[]{policy, client, registeredService});
                AuditableContext context = AuditableContext.builder().registeredService(registeredService).properties(CollectionUtils.wrap((String)Client.class.getSimpleName(), (Object)client)).build();
                AuditableExecutionResult result = this.delegatedAuthenticationPolicyEnforcer.execute(context);
                result.throwExceptionIfNeeded();
            }
        });
    }

    @Generated
    public DelegatedAuthenticationServiceTicketValidationAuthorizer(ServicesManager servicesManager, AuditableExecution delegatedAuthenticationPolicyEnforcer) {
        this.servicesManager = servicesManager;
        this.delegatedAuthenticationPolicyEnforcer = delegatedAuthenticationPolicyEnforcer;
    }
}

