/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.TemplateWizardBuilder;
import org.apache.syncope.client.console.wizards.any.UserWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.PageReference;

public class UserTemplateWizardBuilder
extends UserWizardBuilder
implements TemplateWizardBuilder<UserTO> {
    private static final long serialVersionUID = 6716803168859873877L;
    protected final TemplatableTO templatable;

    public UserTemplateWizardBuilder(UserTO template, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, UserRestClient userRestClient, PageReference pageRef) {
        super(anyTypeClasses, formLayoutInfo, userRestClient, pageRef);
        this.templatable = null;
        if (template == null) {
            this.setItem((AnyWrapper<UserTO>)new UserWrapper(new UserTO()));
        } else {
            this.setItem((AnyWrapper<UserTO>)new UserWrapper(template));
        }
    }

    public UserTemplateWizardBuilder(TemplatableTO templatable, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, UserRestClient userRestClient, PageReference pageRef) {
        super(anyTypeClasses, formLayoutInfo, userRestClient, pageRef);
        this.templatable = templatable;
        if (templatable.getTemplates().containsKey(AnyTypeKind.USER.name())) {
            this.setItem((AnyWrapper<UserTO>)new UserWrapper((UserTO)UserTO.class.cast(templatable.getTemplates().get(AnyTypeKind.USER.name()))));
        } else {
            UserTO userTO = new UserTO();
            if (templatable instanceof RealmTO) {
                userTO.setRealm(String.format("'%s'", RealmsUtils.getFullPath(((RealmTO)RealmTO.class.cast(templatable)).getFullPath())));
            }
            this.setItem((AnyWrapper<UserTO>)new UserWrapper(userTO));
        }
    }

    @Override
    protected Optional<Details<UserTO>> addOptionalDetailsPanel(AnyWrapper<UserTO> modelObject) {
        Optional<Details<UserTO>> details = super.addOptionalDetailsPanel(modelObject);
        if (this.templatable instanceof RealmTO) {
            details.ifPresent(Details::disableRealmSpecification);
        }
        return details;
    }

    @Override
    public AjaxWizard<AnyWrapper<UserTO>> build(String id) {
        return super.build(id, AjaxWizard.Mode.TEMPLATE);
    }
}

