/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.SynapseController;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;

public class SynapseControllerFactory {
    private static final Log log = LogFactory.getLog(SynapseControllerFactory.class);

    public static SynapseController createSynapseController(ServerConfigurationInformation information) {
        SynapseControllerFactory.validate(information);
        return SynapseControllerFactory.loadSynapseController(information);
    }

    private static SynapseController loadSynapseController(ServerConfigurationInformation information) {
        String provider = information.getServerControllerProvider();
        try {
            Class<?> aClass = SynapseControllerFactory.class.getClassLoader().loadClass(provider);
            Object instance = aClass.newInstance();
            if (instance != null && instance instanceof SynapseController) {
                return (SynapseController)instance;
            }
            SynapseControllerFactory.handleFatal("Invalid class as SynapseController : Class Name : " + provider);
        }
        catch (ClassNotFoundException e) {
            SynapseControllerFactory.handleFatal("A SynapseController cannot be found for class name : " + provider, e);
        }
        catch (IllegalAccessException e) {
            SynapseControllerFactory.handleFatal("Error creating a instance from class : " + provider, e);
        }
        catch (InstantiationException e) {
            SynapseControllerFactory.handleFatal("Error creating a instance from class : " + provider, e);
        }
        return null;
    }

    private static void validate(ServerConfigurationInformation information) {
        if (information == null) {
            SynapseControllerFactory.handleFatal("Server Configuration Information is null");
        } else {
            SynapseControllerFactory.validatePath("Synapse home", information.getSynapseHome());
            if (information.isCreateNewInstance()) {
                SynapseControllerFactory.validatePath("Axis2 repository", information.getAxis2RepoLocation());
                SynapseControllerFactory.validatePath("axis2.xml location", information.getAxis2Xml());
            }
            SynapseControllerFactory.validatePath("synapse.xml location", information.getSynapseXMLLocation());
            String serverName = information.getServerName();
            if (serverName == null) {
                try {
                    serverName = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                log.info((Object)("The server name was not specified, defaulting to : " + serverName));
            } else {
                log.info((Object)("Using server name : " + serverName));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using Server Configuration As : " + information));
            }
            log.info((Object)("The timeout handler will run every : " + SynapseConfigUtils.getTimeoutHandlerInterval() / 1000L + "s"));
        }
    }

    private static void validatePath(String msgPre, String path) {
        if (path == null) {
            SynapseControllerFactory.handleFatal("The " + msgPre + " must be set as a system property or init-parameter");
        } else if (!new File(path).exists()) {
            SynapseControllerFactory.handleFatal("The " + msgPre + " " + path + " doesn't exist");
        } else {
            log.info((Object)("Using " + msgPre + " : " + new File(path).getAbsolutePath()));
        }
    }

    private static void handleFatal(String msg) {
        log.fatal((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleFatal(String msg, Exception e) {
        log.fatal((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

